// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a
 * Microsoft managed key. For additional control, a customer-managed key can be used instead.
 */
@Fluent
public final class EncryptionProperties {
    /*
     * Type of the key source.
     */
    @JsonProperty(value = "keySource")
    private KeySource keySource;

    /*
     * Additional details when using Microsoft.KeyVault
     */
    @JsonProperty(value = "keyVaultProperties")
    private KeyVaultProperties keyVaultProperties;

    /**
     * Creates an instance of EncryptionProperties class.
     */
    public EncryptionProperties() {
    }

    /**
     * Get the keySource property: Type of the key source.
     * 
     * @return the keySource value.
     */
    public KeySource keySource() {
        return this.keySource;
    }

    /**
     * Set the keySource property: Type of the key source.
     * 
     * @param keySource the keySource value to set.
     * @return the EncryptionProperties object itself.
     */
    public EncryptionProperties withKeySource(KeySource keySource) {
        this.keySource = keySource;
        return this;
    }

    /**
     * Get the keyVaultProperties property: Additional details when using Microsoft.KeyVault.
     * 
     * @return the keyVaultProperties value.
     */
    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    /**
     * Set the keyVaultProperties property: Additional details when using Microsoft.KeyVault.
     * 
     * @param keyVaultProperties the keyVaultProperties value to set.
     * @return the EncryptionProperties object itself.
     */
    public EncryptionProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyVaultProperties() != null) {
            keyVaultProperties().validate();
        }
    }
}
