// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Network access profile for Batch endpoint.
 */
@Fluent
public final class EndpointAccessProfile {
    /*
     * The default action when there is no IPRule matched.
     * 
     * Default action for endpoint access. It is only applicable when publicNetworkAccess is enabled.
     */
    @JsonProperty(value = "defaultAction", required = true)
    private EndpointAccessDefaultAction defaultAction;

    /*
     * Array of IP ranges to filter client IP address.
     */
    @JsonProperty(value = "ipRules")
    private List<IpRule> ipRules;

    /**
     * Creates an instance of EndpointAccessProfile class.
     */
    public EndpointAccessProfile() {
    }

    /**
     * Get the defaultAction property: The default action when there is no IPRule matched.
     * 
     * Default action for endpoint access. It is only applicable when publicNetworkAccess is enabled.
     * 
     * @return the defaultAction value.
     */
    public EndpointAccessDefaultAction defaultAction() {
        return this.defaultAction;
    }

    /**
     * Set the defaultAction property: The default action when there is no IPRule matched.
     * 
     * Default action for endpoint access. It is only applicable when publicNetworkAccess is enabled.
     * 
     * @param defaultAction the defaultAction value to set.
     * @return the EndpointAccessProfile object itself.
     */
    public EndpointAccessProfile withDefaultAction(EndpointAccessDefaultAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    /**
     * Get the ipRules property: Array of IP ranges to filter client IP address.
     * 
     * @return the ipRules value.
     */
    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    /**
     * Set the ipRules property: Array of IP ranges to filter client IP address.
     * 
     * @param ipRules the ipRules value to set.
     * @return the EndpointAccessProfile object itself.
     */
    public EndpointAccessProfile withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (defaultAction() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property defaultAction in model EndpointAccessProfile"));
        }
        if (ipRules() != null) {
            ipRules().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EndpointAccessProfile.class);
}
