// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A domain name and connection details used to access a dependency.
 */
@Immutable
public final class EndpointDependency {
    /*
     * The domain name of the dependency. Domain names may be fully qualified or may contain a * wildcard.
     */
    @JsonProperty(value = "domainName", access = JsonProperty.Access.WRITE_ONLY)
    private String domainName;

    /*
     * Human-readable supplemental information about the dependency and when it is applicable.
     */
    @JsonProperty(value = "description", access = JsonProperty.Access.WRITE_ONLY)
    private String description;

    /*
     * The list of connection details for this endpoint.
     */
    @JsonProperty(value = "endpointDetails", access = JsonProperty.Access.WRITE_ONLY)
    private List<EndpointDetail> endpointDetails;

    /**
     * Creates an instance of EndpointDependency class.
     */
    public EndpointDependency() {
    }

    /**
     * Get the domainName property: The domain name of the dependency. Domain names may be fully qualified or may
     * contain a * wildcard.
     * 
     * @return the domainName value.
     */
    public String domainName() {
        return this.domainName;
    }

    /**
     * Get the description property: Human-readable supplemental information about the dependency and when it is
     * applicable.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the endpointDetails property: The list of connection details for this endpoint.
     * 
     * @return the endpointDetails value.
     */
    public List<EndpointDetail> endpointDetails() {
        return this.endpointDetails;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpointDetails() != null) {
            endpointDetails().forEach(e -> e.validate());
        }
    }
}
