// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;

/**
 * Fixed scale settings for the pool.
 */
@Fluent
public final class FixedScaleSettings {
    /*
     * The timeout for allocation of compute nodes to the pool.
     * 
     * The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The
     * minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request
     * with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
     */
    @JsonProperty(value = "resizeTimeout")
    private Duration resizeTimeout;

    /*
     * The desired number of dedicated compute nodes in the pool.
     * 
     * At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     */
    @JsonProperty(value = "targetDedicatedNodes")
    private Integer targetDedicatedNodes;

    /*
     * The desired number of Spot/low-priority compute nodes in the pool.
     * 
     * At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     */
    @JsonProperty(value = "targetLowPriorityNodes")
    private Integer targetLowPriorityNodes;

    /*
     * Determines what to do with a node and its running task(s) after it has been selected for deallocation.
     * 
     * If omitted, the default value is Requeue.
     */
    @JsonProperty(value = "nodeDeallocationOption")
    private ComputeNodeDeallocationOption nodeDeallocationOption;

    /**
     * Creates an instance of FixedScaleSettings class.
     */
    public FixedScaleSettings() {
    }

    /**
     * Get the resizeTimeout property: The timeout for allocation of compute nodes to the pool.
     * 
     * The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The
     * minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request
     * with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
     * 
     * @return the resizeTimeout value.
     */
    public Duration resizeTimeout() {
        return this.resizeTimeout;
    }

    /**
     * Set the resizeTimeout property: The timeout for allocation of compute nodes to the pool.
     * 
     * The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The
     * minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request
     * with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
     * 
     * @param resizeTimeout the resizeTimeout value to set.
     * @return the FixedScaleSettings object itself.
     */
    public FixedScaleSettings withResizeTimeout(Duration resizeTimeout) {
        this.resizeTimeout = resizeTimeout;
        return this;
    }

    /**
     * Get the targetDedicatedNodes property: The desired number of dedicated compute nodes in the pool.
     * 
     * At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     * 
     * @return the targetDedicatedNodes value.
     */
    public Integer targetDedicatedNodes() {
        return this.targetDedicatedNodes;
    }

    /**
     * Set the targetDedicatedNodes property: The desired number of dedicated compute nodes in the pool.
     * 
     * At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     * 
     * @param targetDedicatedNodes the targetDedicatedNodes value to set.
     * @return the FixedScaleSettings object itself.
     */
    public FixedScaleSettings withTargetDedicatedNodes(Integer targetDedicatedNodes) {
        this.targetDedicatedNodes = targetDedicatedNodes;
        return this;
    }

    /**
     * Get the targetLowPriorityNodes property: The desired number of Spot/low-priority compute nodes in the pool.
     * 
     * At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     * 
     * @return the targetLowPriorityNodes value.
     */
    public Integer targetLowPriorityNodes() {
        return this.targetLowPriorityNodes;
    }

    /**
     * Set the targetLowPriorityNodes property: The desired number of Spot/low-priority compute nodes in the pool.
     * 
     * At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     * 
     * @param targetLowPriorityNodes the targetLowPriorityNodes value to set.
     * @return the FixedScaleSettings object itself.
     */
    public FixedScaleSettings withTargetLowPriorityNodes(Integer targetLowPriorityNodes) {
        this.targetLowPriorityNodes = targetLowPriorityNodes;
        return this;
    }

    /**
     * Get the nodeDeallocationOption property: Determines what to do with a node and its running task(s) after it has
     * been selected for deallocation.
     * 
     * If omitted, the default value is Requeue.
     * 
     * @return the nodeDeallocationOption value.
     */
    public ComputeNodeDeallocationOption nodeDeallocationOption() {
        return this.nodeDeallocationOption;
    }

    /**
     * Set the nodeDeallocationOption property: Determines what to do with a node and its running task(s) after it has
     * been selected for deallocation.
     * 
     * If omitted, the default value is Requeue.
     * 
     * @param nodeDeallocationOption the nodeDeallocationOption value to set.
     * @return the FixedScaleSettings object itself.
     */
    public FixedScaleSettings withNodeDeallocationOption(ComputeNodeDeallocationOption nodeDeallocationOption) {
        this.nodeDeallocationOption = nodeDeallocationOption;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
