// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Rule to filter client IP address.
 */
@Fluent
public final class IpRule {
    /*
     * Action when client IP address is matched.
     */
    @JsonProperty(value = "action", required = true)
    private String action = "Allow";

    /*
     * The IP address or IP address range to filter
     * 
     * IPv4 address, or IPv4 address range in CIDR format.
     */
    @JsonProperty(value = "value", required = true)
    private String value;

    /**
     * Creates an instance of IpRule class.
     */
    public IpRule() {
    }

    /**
     * Get the action property: Action when client IP address is matched.
     * 
     * @return the action value.
     */
    public String action() {
        return this.action;
    }

    /**
     * Set the action property: Action when client IP address is matched.
     * 
     * @param action the action value to set.
     * @return the IpRule object itself.
     */
    public IpRule withAction(String action) {
        this.action = action;
        return this;
    }

    /**
     * Get the value property: The IP address or IP address range to filter
     * 
     * IPv4 address, or IPv4 address range in CIDR format.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The IP address or IP address range to filter
     * 
     * IPv4 address, or IPv4 address range in CIDR format.
     * 
     * @param value the value value to set.
     * @return the IpRule object itself.
     */
    public IpRule withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER
                .logExceptionAsError(new IllegalArgumentException("Missing required property value in model IpRule"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IpRule.class);
}
