// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Identifies the Azure key vault associated with a Batch account.
 */
@Fluent
public final class KeyVaultReference {
    /*
     * The resource ID of the Azure key vault associated with the Batch account.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * The URL of the Azure key vault associated with the Batch account.
     */
    @JsonProperty(value = "url", required = true)
    private String url;

    /**
     * Creates an instance of KeyVaultReference class.
     */
    public KeyVaultReference() {
    }

    /**
     * Get the id property: The resource ID of the Azure key vault associated with the Batch account.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The resource ID of the Azure key vault associated with the Batch account.
     * 
     * @param id the id value to set.
     * @return the KeyVaultReference object itself.
     */
    public KeyVaultReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the url property: The URL of the Azure key vault associated with the Batch account.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: The URL of the Azure key vault associated with the Batch account.
     * 
     * @param url the url value to set.
     * @return the KeyVaultReference object itself.
     */
    public KeyVaultReference withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property id in model KeyVaultReference"));
        }
        if (url() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property url in model KeyVaultReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultReference.class);
}
