// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The ManagedDisk model.
 */
@Fluent
public final class ManagedDisk {
    /*
     * The storage account type for use in creating data disks or OS disk.
     */
    @JsonProperty(value = "storageAccountType")
    private StorageAccountType storageAccountType;

    /**
     * Creates an instance of ManagedDisk class.
     */
    public ManagedDisk() {
    }

    /**
     * Get the storageAccountType property: The storage account type for use in creating data disks or OS disk.
     * 
     * @return the storageAccountType value.
     */
    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    /**
     * Set the storageAccountType property: The storage account type for use in creating data disks or OS disk.
     * 
     * @param storageAccountType the storageAccountType value to set.
     * @return the ManagedDisk object itself.
     */
    public ManagedDisk withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
