// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A name-value pair associated with a Batch service resource.
 * 
 * The Batch service does not assign any meaning to this metadata; it is solely for the use of user code.
 */
@Fluent
public final class MetadataItem {
    /*
     * The name of the metadata item.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The value of the metadata item.
     */
    @JsonProperty(value = "value", required = true)
    private String value;

    /**
     * Creates an instance of MetadataItem class.
     */
    public MetadataItem() {
    }

    /**
     * Get the name property: The name of the metadata item.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the metadata item.
     * 
     * @param name the name value to set.
     * @return the MetadataItem object itself.
     */
    public MetadataItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The value of the metadata item.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the metadata item.
     * 
     * @param value the value value to set.
     * @return the MetadataItem object itself.
     */
    public MetadataItem withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property name in model MetadataItem"));
        }
        if (value() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property value in model MetadataItem"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MetadataItem.class);
}
