// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The network configuration for a pool.
 */
@Fluent
public final class NetworkConfiguration {
    /*
     * The ARM resource identifier of the virtual network subnet which the compute nodes of the pool will join. This is
     * of the form
     * /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{
     * subnet}.
     * 
     * The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet
     * should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have
     * enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The
     * 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access
     * Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch
     * service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified
     * VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified
     * subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the
     * specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be
     * enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876
     * and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service
     * configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port
     * 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see:
     * https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
     */
    @JsonProperty(value = "subnetId")
    private String subnetId;

    /*
     * The scope of dynamic vnet assignment.
     */
    @JsonProperty(value = "dynamicVnetAssignmentScope")
    private DynamicVNetAssignmentScope dynamicVnetAssignmentScope;

    /*
     * The endpoint configuration for a pool.
     * 
     * Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
     */
    @JsonProperty(value = "endpointConfiguration")
    private PoolEndpointConfiguration endpointConfiguration;

    /*
     * This property is only supported on Pools with the virtualMachineConfiguration property.
     */
    @JsonProperty(value = "publicIPAddressConfiguration")
    private PublicIpAddressConfiguration publicIpAddressConfiguration;

    /*
     * Whether this pool should enable accelerated networking.
     * 
     * Accelerated networking enables single root I/O virtualization (SR-IOV) to a VM, which may lead to improved
     * networking performance. For more details, see:
     * https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
     */
    @JsonProperty(value = "enableAcceleratedNetworking")
    private Boolean enableAcceleratedNetworking;

    /**
     * Creates an instance of NetworkConfiguration class.
     */
    public NetworkConfiguration() {
    }

    /**
     * Get the subnetId property: The ARM resource identifier of the virtual network subnet which the compute nodes of
     * the pool will join. This is of the form
     * /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
     * 
     * The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet
     * should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have
     * enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The
     * 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access
     * Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch
     * service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified
     * VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified
     * subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the
     * specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be
     * enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876
     * and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service
     * configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port
     * 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see:
     * https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
     * 
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.subnetId;
    }

    /**
     * Set the subnetId property: The ARM resource identifier of the virtual network subnet which the compute nodes of
     * the pool will join. This is of the form
     * /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
     * 
     * The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet
     * should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have
     * enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The
     * 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access
     * Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch
     * service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified
     * VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified
     * subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the
     * specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be
     * enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876
     * and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service
     * configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port
     * 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see:
     * https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
     * 
     * @param subnetId the subnetId value to set.
     * @return the NetworkConfiguration object itself.
     */
    public NetworkConfiguration withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    /**
     * Get the dynamicVnetAssignmentScope property: The scope of dynamic vnet assignment.
     * 
     * @return the dynamicVnetAssignmentScope value.
     */
    public DynamicVNetAssignmentScope dynamicVnetAssignmentScope() {
        return this.dynamicVnetAssignmentScope;
    }

    /**
     * Set the dynamicVnetAssignmentScope property: The scope of dynamic vnet assignment.
     * 
     * @param dynamicVnetAssignmentScope the dynamicVnetAssignmentScope value to set.
     * @return the NetworkConfiguration object itself.
     */
    public NetworkConfiguration withDynamicVnetAssignmentScope(DynamicVNetAssignmentScope dynamicVnetAssignmentScope) {
        this.dynamicVnetAssignmentScope = dynamicVnetAssignmentScope;
        return this;
    }

    /**
     * Get the endpointConfiguration property: The endpoint configuration for a pool.
     * 
     * Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
     * 
     * @return the endpointConfiguration value.
     */
    public PoolEndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    /**
     * Set the endpointConfiguration property: The endpoint configuration for a pool.
     * 
     * Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
     * 
     * @param endpointConfiguration the endpointConfiguration value to set.
     * @return the NetworkConfiguration object itself.
     */
    public NetworkConfiguration withEndpointConfiguration(PoolEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        return this;
    }

    /**
     * Get the publicIpAddressConfiguration property: This property is only supported on Pools with the
     * virtualMachineConfiguration property.
     * 
     * @return the publicIpAddressConfiguration value.
     */
    public PublicIpAddressConfiguration publicIpAddressConfiguration() {
        return this.publicIpAddressConfiguration;
    }

    /**
     * Set the publicIpAddressConfiguration property: This property is only supported on Pools with the
     * virtualMachineConfiguration property.
     * 
     * @param publicIpAddressConfiguration the publicIpAddressConfiguration value to set.
     * @return the NetworkConfiguration object itself.
     */
    public NetworkConfiguration
        withPublicIpAddressConfiguration(PublicIpAddressConfiguration publicIpAddressConfiguration) {
        this.publicIpAddressConfiguration = publicIpAddressConfiguration;
        return this;
    }

    /**
     * Get the enableAcceleratedNetworking property: Whether this pool should enable accelerated networking.
     * 
     * Accelerated networking enables single root I/O virtualization (SR-IOV) to a VM, which may lead to improved
     * networking performance. For more details, see:
     * https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
     * 
     * @return the enableAcceleratedNetworking value.
     */
    public Boolean enableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    /**
     * Set the enableAcceleratedNetworking property: Whether this pool should enable accelerated networking.
     * 
     * Accelerated networking enables single root I/O virtualization (SR-IOV) to a VM, which may lead to improved
     * networking performance. For more details, see:
     * https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
     * 
     * @param enableAcceleratedNetworking the enableAcceleratedNetworking value to set.
     * @return the NetworkConfiguration object itself.
     */
    public NetworkConfiguration withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpointConfiguration() != null) {
            endpointConfiguration().validate();
        }
        if (publicIpAddressConfiguration() != null) {
            publicIpAddressConfiguration().validate();
        }
    }
}
