// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Network profile for Batch account, which contains network rule settings for each endpoint.
 */
@Fluent
public final class NetworkProfile {
    /*
     * Network access profile for batchAccount endpoint (Batch account data plane API).
     */
    @JsonProperty(value = "accountAccess")
    private EndpointAccessProfile accountAccess;

    /*
     * Network access profile for nodeManagement endpoint (Batch service managing compute nodes for Batch pools).
     */
    @JsonProperty(value = "nodeManagementAccess")
    private EndpointAccessProfile nodeManagementAccess;

    /**
     * Creates an instance of NetworkProfile class.
     */
    public NetworkProfile() {
    }

    /**
     * Get the accountAccess property: Network access profile for batchAccount endpoint (Batch account data plane API).
     * 
     * @return the accountAccess value.
     */
    public EndpointAccessProfile accountAccess() {
        return this.accountAccess;
    }

    /**
     * Set the accountAccess property: Network access profile for batchAccount endpoint (Batch account data plane API).
     * 
     * @param accountAccess the accountAccess value to set.
     * @return the NetworkProfile object itself.
     */
    public NetworkProfile withAccountAccess(EndpointAccessProfile accountAccess) {
        this.accountAccess = accountAccess;
        return this;
    }

    /**
     * Get the nodeManagementAccess property: Network access profile for nodeManagement endpoint (Batch service
     * managing compute nodes for Batch pools).
     * 
     * @return the nodeManagementAccess value.
     */
    public EndpointAccessProfile nodeManagementAccess() {
        return this.nodeManagementAccess;
    }

    /**
     * Set the nodeManagementAccess property: Network access profile for nodeManagement endpoint (Batch service
     * managing compute nodes for Batch pools).
     * 
     * @param nodeManagementAccess the nodeManagementAccess value to set.
     * @return the NetworkProfile object itself.
     */
    public NetworkProfile withNodeManagementAccess(EndpointAccessProfile nodeManagementAccess) {
        this.nodeManagementAccess = nodeManagementAccess;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accountAccess() != null) {
            accountAccess().validate();
        }
        if (nodeManagementAccess() != null) {
            nodeManagementAccess().validate();
        }
    }
}
