// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Node placement configuration for batch pools.
 * 
 * Allocation configuration used by Batch Service to provision the nodes.
 */
@Fluent
public final class NodePlacementConfiguration {
    /*
     * The placement policy for allocating nodes in the pool.
     * 
     * Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional
     * policy.
     */
    @JsonProperty(value = "policy")
    private NodePlacementPolicyType policy;

    /**
     * Creates an instance of NodePlacementConfiguration class.
     */
    public NodePlacementConfiguration() {
    }

    /**
     * Get the policy property: The placement policy for allocating nodes in the pool.
     * 
     * Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional
     * policy.
     * 
     * @return the policy value.
     */
    public NodePlacementPolicyType policy() {
        return this.policy;
    }

    /**
     * Set the policy property: The placement policy for allocating nodes in the pool.
     * 
     * Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional
     * policy.
     * 
     * @param policy the policy value to set.
     * @return the NodePlacementConfiguration object itself.
     */
    public NodePlacementConfiguration withPolicy(NodePlacementPolicyType policy) {
        this.policy = policy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
