// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The placement policy for allocating nodes in the pool.
 * 
 * The default value is regional.
 */
public enum NodePlacementPolicyType {
    /**
     * Enum value Regional.
     */
    REGIONAL("Regional"),

    /**
     * Enum value Zonal.
     */
    ZONAL("Zonal");

    /**
     * The actual serialized value for a NodePlacementPolicyType instance.
     */
    private final String value;

    NodePlacementPolicyType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a NodePlacementPolicyType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed NodePlacementPolicyType object, or null if unable to parse.
     */
    @JsonCreator
    public static NodePlacementPolicyType fromString(String value) {
        if (value == null) {
            return null;
        }
        NodePlacementPolicyType[] items = NodePlacementPolicyType.values();
        for (NodePlacementPolicyType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
