// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.resourcemanager.batch.fluent.models.PrivateEndpointConnectionInner;
import java.util.List;

/**
 * An immutable client-side representation of PrivateEndpointConnection.
 */
public interface PrivateEndpointConnection {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the etag property: The ETag of the resource, used for concurrency statements.
     * 
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the provisioningState property: The provisioning state of the private endpoint connection.
     * 
     * @return the provisioningState value.
     */
    PrivateEndpointConnectionProvisioningState provisioningState();

    /**
     * Gets the privateEndpoint property: The private endpoint of the private endpoint connection.
     * 
     * @return the privateEndpoint value.
     */
    PrivateEndpoint privateEndpoint();

    /**
     * Gets the groupIds property: The group id of the private endpoint connection.
     * 
     * The value has one and only one group id.
     * 
     * @return the groupIds value.
     */
    List<String> groupIds();

    /**
     * Gets the privateLinkServiceConnectionState property: The private link service connection state of the private
     * endpoint connection.
     * 
     * @return the privateLinkServiceConnectionState value.
     */
    PrivateLinkServiceConnectionState privateLinkServiceConnectionState();

    /**
     * Gets the inner com.azure.resourcemanager.batch.fluent.models.PrivateEndpointConnectionInner object.
     * 
     * @return the inner object.
     */
    PrivateEndpointConnectionInner innerModel();
}
