// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The provisioning state of the private endpoint connection.
 */
public enum PrivateEndpointConnectionProvisioningState {
    /**
     * Enum value Creating.
     */
    CREATING("Creating"),

    /**
     * Enum value Updating.
     */
    UPDATING("Updating"),

    /**
     * Enum value Deleting.
     */
    DELETING("Deleting"),

    /**
     * Enum value Succeeded.
     */
    SUCCEEDED("Succeeded"),

    /**
     * Enum value Failed.
     */
    FAILED("Failed"),

    /**
     * Enum value Cancelled.
     */
    CANCELLED("Cancelled");

    /**
     * The actual serialized value for a PrivateEndpointConnectionProvisioningState instance.
     */
    private final String value;

    PrivateEndpointConnectionProvisioningState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a PrivateEndpointConnectionProvisioningState instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed PrivateEndpointConnectionProvisioningState object, or null if unable to parse.
     */
    @JsonCreator
    public static PrivateEndpointConnectionProvisioningState fromString(String value) {
        if (value == null) {
            return null;
        }
        PrivateEndpointConnectionProvisioningState[] items = PrivateEndpointConnectionProvisioningState.values();
        for (PrivateEndpointConnectionProvisioningState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
