// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Details about the current or last completed resize operation.
 * 
 * Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed
 * operation (if the AllocationState is Steady).
 */
@Fluent
public final class ResizeOperationStatus {
    /*
     * The desired number of dedicated compute nodes in the pool.
     */
    @JsonProperty(value = "targetDedicatedNodes")
    private Integer targetDedicatedNodes;

    /*
     * The desired number of Spot/low-priority compute nodes in the pool.
     */
    @JsonProperty(value = "targetLowPriorityNodes")
    private Integer targetLowPriorityNodes;

    /*
     * The timeout for allocation of compute nodes to the pool or removal of compute nodes from the pool.
     * 
     * The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the
     * Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad
     * Request).
     */
    @JsonProperty(value = "resizeTimeout")
    private Duration resizeTimeout;

    /*
     * Determines what to do with a node and its running task(s) after it has been selected for deallocation.
     * 
     * The default value is requeue.
     */
    @JsonProperty(value = "nodeDeallocationOption")
    private ComputeNodeDeallocationOption nodeDeallocationOption;

    /*
     * The time when this resize operation was started.
     */
    @JsonProperty(value = "startTime")
    private OffsetDateTime startTime;

    /*
     * Details of any errors encountered while performing the last resize on the pool.
     * 
     * This property is set only if an error occurred during the last pool resize, and only when the pool
     * allocationState is Steady.
     */
    @JsonProperty(value = "errors")
    private List<ResizeError> errors;

    /**
     * Creates an instance of ResizeOperationStatus class.
     */
    public ResizeOperationStatus() {
    }

    /**
     * Get the targetDedicatedNodes property: The desired number of dedicated compute nodes in the pool.
     * 
     * @return the targetDedicatedNodes value.
     */
    public Integer targetDedicatedNodes() {
        return this.targetDedicatedNodes;
    }

    /**
     * Set the targetDedicatedNodes property: The desired number of dedicated compute nodes in the pool.
     * 
     * @param targetDedicatedNodes the targetDedicatedNodes value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withTargetDedicatedNodes(Integer targetDedicatedNodes) {
        this.targetDedicatedNodes = targetDedicatedNodes;
        return this;
    }

    /**
     * Get the targetLowPriorityNodes property: The desired number of Spot/low-priority compute nodes in the pool.
     * 
     * @return the targetLowPriorityNodes value.
     */
    public Integer targetLowPriorityNodes() {
        return this.targetLowPriorityNodes;
    }

    /**
     * Set the targetLowPriorityNodes property: The desired number of Spot/low-priority compute nodes in the pool.
     * 
     * @param targetLowPriorityNodes the targetLowPriorityNodes value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withTargetLowPriorityNodes(Integer targetLowPriorityNodes) {
        this.targetLowPriorityNodes = targetLowPriorityNodes;
        return this;
    }

    /**
     * Get the resizeTimeout property: The timeout for allocation of compute nodes to the pool or removal of compute
     * nodes from the pool.
     * 
     * The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the
     * Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad
     * Request).
     * 
     * @return the resizeTimeout value.
     */
    public Duration resizeTimeout() {
        return this.resizeTimeout;
    }

    /**
     * Set the resizeTimeout property: The timeout for allocation of compute nodes to the pool or removal of compute
     * nodes from the pool.
     * 
     * The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the
     * Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad
     * Request).
     * 
     * @param resizeTimeout the resizeTimeout value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withResizeTimeout(Duration resizeTimeout) {
        this.resizeTimeout = resizeTimeout;
        return this;
    }

    /**
     * Get the nodeDeallocationOption property: Determines what to do with a node and its running task(s) after it has
     * been selected for deallocation.
     * 
     * The default value is requeue.
     * 
     * @return the nodeDeallocationOption value.
     */
    public ComputeNodeDeallocationOption nodeDeallocationOption() {
        return this.nodeDeallocationOption;
    }

    /**
     * Set the nodeDeallocationOption property: Determines what to do with a node and its running task(s) after it has
     * been selected for deallocation.
     * 
     * The default value is requeue.
     * 
     * @param nodeDeallocationOption the nodeDeallocationOption value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withNodeDeallocationOption(ComputeNodeDeallocationOption nodeDeallocationOption) {
        this.nodeDeallocationOption = nodeDeallocationOption;
        return this;
    }

    /**
     * Get the startTime property: The time when this resize operation was started.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The time when this resize operation was started.
     * 
     * @param startTime the startTime value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the errors property: Details of any errors encountered while performing the last resize on the pool.
     * 
     * This property is set only if an error occurred during the last pool resize, and only when the pool
     * allocationState is Steady.
     * 
     * @return the errors value.
     */
    public List<ResizeError> errors() {
        return this.errors;
    }

    /**
     * Set the errors property: Details of any errors encountered while performing the last resize on the pool.
     * 
     * This property is set only if an error occurred during the last pool resize, and only when the pool
     * allocationState is Steady.
     * 
     * @param errors the errors value to set.
     * @return the ResizeOperationStatus object itself.
     */
    public ResizeOperationStatus withErrors(List<ResizeError> errors) {
        this.errors = errors;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (errors() != null) {
            errors().forEach(e -> e.validate());
        }
    }
}
