// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Scale settings for the pool
 * 
 * Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is
 * specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not
 * specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
 */
@Fluent
public final class ScaleSettings {
    /*
     * Fixed scale settings for the pool.
     * 
     * This property and autoScale are mutually exclusive and one of the properties must be specified.
     */
    @JsonProperty(value = "fixedScale")
    private FixedScaleSettings fixedScale;

    /*
     * AutoScale settings for the pool.
     * 
     * This property and fixedScale are mutually exclusive and one of the properties must be specified.
     */
    @JsonProperty(value = "autoScale")
    private AutoScaleSettings autoScale;

    /**
     * Creates an instance of ScaleSettings class.
     */
    public ScaleSettings() {
    }

    /**
     * Get the fixedScale property: Fixed scale settings for the pool.
     * 
     * This property and autoScale are mutually exclusive and one of the properties must be specified.
     * 
     * @return the fixedScale value.
     */
    public FixedScaleSettings fixedScale() {
        return this.fixedScale;
    }

    /**
     * Set the fixedScale property: Fixed scale settings for the pool.
     * 
     * This property and autoScale are mutually exclusive and one of the properties must be specified.
     * 
     * @param fixedScale the fixedScale value to set.
     * @return the ScaleSettings object itself.
     */
    public ScaleSettings withFixedScale(FixedScaleSettings fixedScale) {
        this.fixedScale = fixedScale;
        return this;
    }

    /**
     * Get the autoScale property: AutoScale settings for the pool.
     * 
     * This property and fixedScale are mutually exclusive and one of the properties must be specified.
     * 
     * @return the autoScale value.
     */
    public AutoScaleSettings autoScale() {
        return this.autoScale;
    }

    /**
     * Set the autoScale property: AutoScale settings for the pool.
     * 
     * This property and fixedScale are mutually exclusive and one of the properties must be specified.
     * 
     * @param autoScale the autoScale value to set.
     * @return the ScaleSettings object itself.
     */
    public ScaleSettings withAutoScale(AutoScaleSettings autoScale) {
        this.autoScale = autoScale;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (fixedScale() != null) {
            fixedScale().validate();
        }
        if (autoScale() != null) {
            autoScale().validate();
        }
    }
}
