// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.fluent.models.SupportedSkuInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The Batch List supported SKUs operation response.
 */
@Fluent
public final class SupportedSkusResult {
    /*
     * The list of SKUs available for the Batch service in the location.
     */
    @JsonProperty(value = "value", required = true)
    private List<SupportedSkuInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Creates an instance of SupportedSkusResult class.
     */
    public SupportedSkusResult() {
    }

    /**
     * Get the value property: The list of SKUs available for the Batch service in the location.
     * 
     * @return the value value.
     */
    public List<SupportedSkuInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of SKUs available for the Batch service in the location.
     * 
     * @param value the value value to set.
     * @return the SupportedSkusResult object itself.
     */
    public SupportedSkusResult withValue(List<SupportedSkuInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property value in model SupportedSkusResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SupportedSkusResult.class);
}
