// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies the security settings like secure boot and vTPM used while creating the virtual machine.
 */
@Fluent
public final class UefiSettings {
    /*
     * Specifies whether secure boot should be enabled on the virtual machine.
     */
    @JsonProperty(value = "secureBootEnabled")
    private Boolean secureBootEnabled;

    /*
     * Specifies whether vTPM should be enabled on the virtual machine.
     */
    @JsonProperty(value = "vTpmEnabled")
    private Boolean vTpmEnabled;

    /**
     * Creates an instance of UefiSettings class.
     */
    public UefiSettings() {
    }

    /**
     * Get the secureBootEnabled property: Specifies whether secure boot should be enabled on the virtual machine.
     * 
     * @return the secureBootEnabled value.
     */
    public Boolean secureBootEnabled() {
        return this.secureBootEnabled;
    }

    /**
     * Set the secureBootEnabled property: Specifies whether secure boot should be enabled on the virtual machine.
     * 
     * @param secureBootEnabled the secureBootEnabled value to set.
     * @return the UefiSettings object itself.
     */
    public UefiSettings withSecureBootEnabled(Boolean secureBootEnabled) {
        this.secureBootEnabled = secureBootEnabled;
        return this;
    }

    /**
     * Get the vTpmEnabled property: Specifies whether vTPM should be enabled on the virtual machine.
     * 
     * @return the vTpmEnabled value.
     */
    public Boolean vTpmEnabled() {
        return this.vTpmEnabled;
    }

    /**
     * Set the vTpmEnabled property: Specifies whether vTPM should be enabled on the virtual machine.
     * 
     * @param vTpmEnabled the vTpmEnabled value to set.
     * @return the UefiSettings object itself.
     */
    public UefiSettings withVTpmEnabled(Boolean vTpmEnabled) {
        this.vTpmEnabled = vTpmEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
