// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties used to create a user account on a Windows node.
 */
@Fluent
public final class WindowsUserConfiguration {
    /*
     * Login mode for user
     * 
     * Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode
     * and for CloudServiceConfiguration pools is batch mode.
     */
    @JsonProperty(value = "loginMode")
    private LoginMode loginMode;

    /**
     * Creates an instance of WindowsUserConfiguration class.
     */
    public WindowsUserConfiguration() {
    }

    /**
     * Get the loginMode property: Login mode for user
     * 
     * Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode
     * and for CloudServiceConfiguration pools is batch mode.
     * 
     * @return the loginMode value.
     */
    public LoginMode loginMode() {
        return this.loginMode;
    }

    /**
     * Set the loginMode property: Login mode for user
     * 
     * Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode
     * and for CloudServiceConfiguration pools is batch mode.
     * 
     * @param loginMode the loginMode value to set.
     * @return the WindowsUserConfiguration object itself.
     */
    public WindowsUserConfiguration withLoginMode(LoginMode loginMode) {
        this.loginMode = loginMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
