/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.resourcemanager.batch.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageProperties;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.KeyVaultReference;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PoolAllocationMode;
import com.azure.resourcemanager.batch.models.ProvisioningState;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import com.azure.resourcemanager.batch.models.VirtualMachineFamilyCoreQuota;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BatchAccountProperties {
    @JsonProperty(value="accountEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String accountEndpoint;
    @JsonProperty(value="nodeManagementEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String nodeManagementEndpoint;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="poolAllocationMode", access=JsonProperty.Access.WRITE_ONLY)
    private PoolAllocationMode poolAllocationMode;
    @JsonProperty(value="keyVaultReference", access=JsonProperty.Access.WRITE_ONLY)
    private KeyVaultReference keyVaultReference;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccessType publicNetworkAccess;
    @JsonProperty(value="networkProfile")
    private NetworkProfile networkProfile;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="autoStorage", access=JsonProperty.Access.WRITE_ONLY)
    private AutoStorageProperties autoStorage;
    @JsonProperty(value="encryption", access=JsonProperty.Access.WRITE_ONLY)
    private EncryptionProperties encryption;
    @JsonProperty(value="dedicatedCoreQuota", access=JsonProperty.Access.WRITE_ONLY)
    private Integer dedicatedCoreQuota;
    @JsonProperty(value="lowPriorityCoreQuota", access=JsonProperty.Access.WRITE_ONLY)
    private Integer lowPriorityCoreQuota;
    @JsonProperty(value="dedicatedCoreQuotaPerVMFamily", access=JsonProperty.Access.WRITE_ONLY)
    private List<VirtualMachineFamilyCoreQuota> dedicatedCoreQuotaPerVMFamily;
    @JsonProperty(value="dedicatedCoreQuotaPerVMFamilyEnforced", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean dedicatedCoreQuotaPerVMFamilyEnforced;
    @JsonProperty(value="poolQuota", access=JsonProperty.Access.WRITE_ONLY)
    private Integer poolQuota;
    @JsonProperty(value="activeJobAndJobScheduleQuota", access=JsonProperty.Access.WRITE_ONLY)
    private Integer activeJobAndJobScheduleQuota;
    @JsonProperty(value="allowedAuthenticationModes", access=JsonProperty.Access.WRITE_ONLY)
    private List<AuthenticationMode> allowedAuthenticationModes;

    public String accountEndpoint() {
        return this.accountEndpoint;
    }

    public String nodeManagementEndpoint() {
        return this.nodeManagementEndpoint;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PoolAllocationMode poolAllocationMode() {
        return this.poolAllocationMode;
    }

    public KeyVaultReference keyVaultReference() {
        return this.keyVaultReference;
    }

    public PublicNetworkAccessType publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public BatchAccountProperties withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public BatchAccountProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public AutoStorageProperties autoStorage() {
        return this.autoStorage;
    }

    public EncryptionProperties encryption() {
        return this.encryption;
    }

    public Integer dedicatedCoreQuota() {
        return this.dedicatedCoreQuota;
    }

    public Integer lowPriorityCoreQuota() {
        return this.lowPriorityCoreQuota;
    }

    public List<VirtualMachineFamilyCoreQuota> dedicatedCoreQuotaPerVMFamily() {
        return this.dedicatedCoreQuotaPerVMFamily;
    }

    public Boolean dedicatedCoreQuotaPerVMFamilyEnforced() {
        return this.dedicatedCoreQuotaPerVMFamilyEnforced;
    }

    public Integer poolQuota() {
        return this.poolQuota;
    }

    public Integer activeJobAndJobScheduleQuota() {
        return this.activeJobAndJobScheduleQuota;
    }

    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.allowedAuthenticationModes;
    }

    public void validate() {
        if (this.keyVaultReference() != null) {
            this.keyVaultReference().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.autoStorage() != null) {
            this.autoStorage().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.dedicatedCoreQuotaPerVMFamily() != null) {
            this.dedicatedCoreQuotaPerVMFamily().forEach(e -> e.validate());
        }
    }
}

