/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BatchAccountUpdateProperties {
    @JsonProperty(value="autoStorage")
    private AutoStorageBaseProperties autoStorage;
    @JsonProperty(value="encryption")
    private EncryptionProperties encryption;
    @JsonProperty(value="allowedAuthenticationModes")
    private List<AuthenticationMode> allowedAuthenticationModes;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccessType publicNetworkAccess;
    @JsonProperty(value="networkProfile")
    private NetworkProfile networkProfile;

    public AutoStorageBaseProperties autoStorage() {
        return this.autoStorage;
    }

    public BatchAccountUpdateProperties withAutoStorage(AutoStorageBaseProperties autoStorage) {
        this.autoStorage = autoStorage;
        return this;
    }

    public EncryptionProperties encryption() {
        return this.encryption;
    }

    public BatchAccountUpdateProperties withEncryption(EncryptionProperties encryption) {
        this.encryption = encryption;
        return this;
    }

    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.allowedAuthenticationModes;
    }

    public BatchAccountUpdateProperties withAllowedAuthenticationModes(List<AuthenticationMode> allowedAuthenticationModes) {
        this.allowedAuthenticationModes = allowedAuthenticationModes;
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public BatchAccountUpdateProperties withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public BatchAccountUpdateProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public void validate() {
        if (this.autoStorage() != null) {
            this.autoStorage().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
    }
}

