/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.batch.fluent.models.PoolProperties;
import com.azure.resourcemanager.batch.models.AllocationState;
import com.azure.resourcemanager.batch.models.ApplicationPackageReference;
import com.azure.resourcemanager.batch.models.AutoScaleRun;
import com.azure.resourcemanager.batch.models.BatchPoolIdentity;
import com.azure.resourcemanager.batch.models.CertificateReference;
import com.azure.resourcemanager.batch.models.DeploymentConfiguration;
import com.azure.resourcemanager.batch.models.InterNodeCommunicationState;
import com.azure.resourcemanager.batch.models.MetadataItem;
import com.azure.resourcemanager.batch.models.MountConfiguration;
import com.azure.resourcemanager.batch.models.NetworkConfiguration;
import com.azure.resourcemanager.batch.models.NodeCommunicationMode;
import com.azure.resourcemanager.batch.models.PoolProvisioningState;
import com.azure.resourcemanager.batch.models.ResizeOperationStatus;
import com.azure.resourcemanager.batch.models.ScaleSettings;
import com.azure.resourcemanager.batch.models.StartTask;
import com.azure.resourcemanager.batch.models.TaskSchedulingPolicy;
import com.azure.resourcemanager.batch.models.UserAccount;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class PoolInner
extends ProxyResource {
    @JsonProperty(value="properties")
    private PoolProperties innerProperties;
    @JsonProperty(value="identity")
    private BatchPoolIdentity identity;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;

    private PoolProperties innerProperties() {
        return this.innerProperties;
    }

    public BatchPoolIdentity identity() {
        return this.identity;
    }

    public PoolInner withIdentity(BatchPoolIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public PoolInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public OffsetDateTime lastModified() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModified();
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public PoolProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime provisioningStateTransitionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningStateTransitionTime();
    }

    public AllocationState allocationState() {
        return this.innerProperties() == null ? null : this.innerProperties().allocationState();
    }

    public OffsetDateTime allocationStateTransitionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().allocationStateTransitionTime();
    }

    public String vmSize() {
        return this.innerProperties() == null ? null : this.innerProperties().vmSize();
    }

    public PoolInner withVmSize(String vmSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withVmSize(vmSize);
        return this;
    }

    public DeploymentConfiguration deploymentConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentConfiguration();
    }

    public PoolInner withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withDeploymentConfiguration(deploymentConfiguration);
        return this;
    }

    public Integer currentDedicatedNodes() {
        return this.innerProperties() == null ? null : this.innerProperties().currentDedicatedNodes();
    }

    public Integer currentLowPriorityNodes() {
        return this.innerProperties() == null ? null : this.innerProperties().currentLowPriorityNodes();
    }

    public ScaleSettings scaleSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleSettings();
    }

    public PoolInner withScaleSettings(ScaleSettings scaleSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withScaleSettings(scaleSettings);
        return this;
    }

    public AutoScaleRun autoScaleRun() {
        return this.innerProperties() == null ? null : this.innerProperties().autoScaleRun();
    }

    public InterNodeCommunicationState interNodeCommunication() {
        return this.innerProperties() == null ? null : this.innerProperties().interNodeCommunication();
    }

    public PoolInner withInterNodeCommunication(InterNodeCommunicationState interNodeCommunication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withInterNodeCommunication(interNodeCommunication);
        return this;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().networkConfiguration();
    }

    public PoolInner withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withNetworkConfiguration(networkConfiguration);
        return this;
    }

    public Integer taskSlotsPerNode() {
        return this.innerProperties() == null ? null : this.innerProperties().taskSlotsPerNode();
    }

    public PoolInner withTaskSlotsPerNode(Integer taskSlotsPerNode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withTaskSlotsPerNode(taskSlotsPerNode);
        return this;
    }

    public TaskSchedulingPolicy taskSchedulingPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().taskSchedulingPolicy();
    }

    public PoolInner withTaskSchedulingPolicy(TaskSchedulingPolicy taskSchedulingPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withTaskSchedulingPolicy(taskSchedulingPolicy);
        return this;
    }

    public List<UserAccount> userAccounts() {
        return this.innerProperties() == null ? null : this.innerProperties().userAccounts();
    }

    public PoolInner withUserAccounts(List<UserAccount> userAccounts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withUserAccounts(userAccounts);
        return this;
    }

    public List<MetadataItem> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public PoolInner withMetadata(List<MetadataItem> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public StartTask startTask() {
        return this.innerProperties() == null ? null : this.innerProperties().startTask();
    }

    public PoolInner withStartTask(StartTask startTask) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withStartTask(startTask);
        return this;
    }

    public List<CertificateReference> certificates() {
        return this.innerProperties() == null ? null : this.innerProperties().certificates();
    }

    public PoolInner withCertificates(List<CertificateReference> certificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withCertificates(certificates);
        return this;
    }

    public List<ApplicationPackageReference> applicationPackages() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationPackages();
    }

    public PoolInner withApplicationPackages(List<ApplicationPackageReference> applicationPackages) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withApplicationPackages(applicationPackages);
        return this;
    }

    public List<String> applicationLicenses() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationLicenses();
    }

    public PoolInner withApplicationLicenses(List<String> applicationLicenses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withApplicationLicenses(applicationLicenses);
        return this;
    }

    public ResizeOperationStatus resizeOperationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().resizeOperationStatus();
    }

    public List<MountConfiguration> mountConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().mountConfiguration();
    }

    public PoolInner withMountConfiguration(List<MountConfiguration> mountConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withMountConfiguration(mountConfiguration);
        return this;
    }

    public NodeCommunicationMode targetNodeCommunicationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().targetNodeCommunicationMode();
    }

    public PoolInner withTargetNodeCommunicationMode(NodeCommunicationMode targetNodeCommunicationMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withTargetNodeCommunicationMode(targetNodeCommunicationMode);
        return this;
    }

    public NodeCommunicationMode currentNodeCommunicationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().currentNodeCommunicationMode();
    }

    public Map<String, String> resourceTags() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceTags();
    }

    public PoolInner withResourceTags(Map<String, String> resourceTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PoolProperties();
        }
        this.innerProperties().withResourceTags(resourceTags);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

