/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.fluent.models;

import com.azure.resourcemanager.batch.models.AllocationState;
import com.azure.resourcemanager.batch.models.ApplicationPackageReference;
import com.azure.resourcemanager.batch.models.AutoScaleRun;
import com.azure.resourcemanager.batch.models.CertificateReference;
import com.azure.resourcemanager.batch.models.DeploymentConfiguration;
import com.azure.resourcemanager.batch.models.InterNodeCommunicationState;
import com.azure.resourcemanager.batch.models.MetadataItem;
import com.azure.resourcemanager.batch.models.MountConfiguration;
import com.azure.resourcemanager.batch.models.NetworkConfiguration;
import com.azure.resourcemanager.batch.models.NodeCommunicationMode;
import com.azure.resourcemanager.batch.models.PoolProvisioningState;
import com.azure.resourcemanager.batch.models.ResizeOperationStatus;
import com.azure.resourcemanager.batch.models.ScaleSettings;
import com.azure.resourcemanager.batch.models.StartTask;
import com.azure.resourcemanager.batch.models.TaskSchedulingPolicy;
import com.azure.resourcemanager.batch.models.UserAccount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class PoolProperties {
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="lastModified", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModified;
    @JsonProperty(value="creationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationTime;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private PoolProvisioningState provisioningState;
    @JsonProperty(value="provisioningStateTransitionTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime provisioningStateTransitionTime;
    @JsonProperty(value="allocationState", access=JsonProperty.Access.WRITE_ONLY)
    private AllocationState allocationState;
    @JsonProperty(value="allocationStateTransitionTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime allocationStateTransitionTime;
    @JsonProperty(value="vmSize")
    private String vmSize;
    @JsonProperty(value="deploymentConfiguration")
    private DeploymentConfiguration deploymentConfiguration;
    @JsonProperty(value="currentDedicatedNodes", access=JsonProperty.Access.WRITE_ONLY)
    private Integer currentDedicatedNodes;
    @JsonProperty(value="currentLowPriorityNodes", access=JsonProperty.Access.WRITE_ONLY)
    private Integer currentLowPriorityNodes;
    @JsonProperty(value="scaleSettings")
    private ScaleSettings scaleSettings;
    @JsonProperty(value="autoScaleRun", access=JsonProperty.Access.WRITE_ONLY)
    private AutoScaleRun autoScaleRun;
    @JsonProperty(value="interNodeCommunication")
    private InterNodeCommunicationState interNodeCommunication;
    @JsonProperty(value="networkConfiguration")
    private NetworkConfiguration networkConfiguration;
    @JsonProperty(value="taskSlotsPerNode")
    private Integer taskSlotsPerNode;
    @JsonProperty(value="taskSchedulingPolicy")
    private TaskSchedulingPolicy taskSchedulingPolicy;
    @JsonProperty(value="userAccounts")
    private List<UserAccount> userAccounts;
    @JsonProperty(value="metadata")
    private List<MetadataItem> metadata;
    @JsonProperty(value="startTask")
    private StartTask startTask;
    @JsonProperty(value="certificates")
    private List<CertificateReference> certificates;
    @JsonProperty(value="applicationPackages")
    private List<ApplicationPackageReference> applicationPackages;
    @JsonProperty(value="applicationLicenses")
    private List<String> applicationLicenses;
    @JsonProperty(value="resizeOperationStatus", access=JsonProperty.Access.WRITE_ONLY)
    private ResizeOperationStatus resizeOperationStatus;
    @JsonProperty(value="mountConfiguration")
    private List<MountConfiguration> mountConfiguration;
    @JsonProperty(value="targetNodeCommunicationMode")
    private NodeCommunicationMode targetNodeCommunicationMode;
    @JsonProperty(value="currentNodeCommunicationMode", access=JsonProperty.Access.WRITE_ONLY)
    private NodeCommunicationMode currentNodeCommunicationMode;
    @JsonProperty(value="resourceTags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> resourceTags;

    public String displayName() {
        return this.displayName;
    }

    public PoolProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public PoolProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime provisioningStateTransitionTime() {
        return this.provisioningStateTransitionTime;
    }

    public AllocationState allocationState() {
        return this.allocationState;
    }

    public OffsetDateTime allocationStateTransitionTime() {
        return this.allocationStateTransitionTime;
    }

    public String vmSize() {
        return this.vmSize;
    }

    public PoolProperties withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public PoolProperties withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.deploymentConfiguration = deploymentConfiguration;
        return this;
    }

    public Integer currentDedicatedNodes() {
        return this.currentDedicatedNodes;
    }

    public Integer currentLowPriorityNodes() {
        return this.currentLowPriorityNodes;
    }

    public ScaleSettings scaleSettings() {
        return this.scaleSettings;
    }

    public PoolProperties withScaleSettings(ScaleSettings scaleSettings) {
        this.scaleSettings = scaleSettings;
        return this;
    }

    public AutoScaleRun autoScaleRun() {
        return this.autoScaleRun;
    }

    public InterNodeCommunicationState interNodeCommunication() {
        return this.interNodeCommunication;
    }

    public PoolProperties withInterNodeCommunication(InterNodeCommunicationState interNodeCommunication) {
        this.interNodeCommunication = interNodeCommunication;
        return this;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public PoolProperties withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public Integer taskSlotsPerNode() {
        return this.taskSlotsPerNode;
    }

    public PoolProperties withTaskSlotsPerNode(Integer taskSlotsPerNode) {
        this.taskSlotsPerNode = taskSlotsPerNode;
        return this;
    }

    public TaskSchedulingPolicy taskSchedulingPolicy() {
        return this.taskSchedulingPolicy;
    }

    public PoolProperties withTaskSchedulingPolicy(TaskSchedulingPolicy taskSchedulingPolicy) {
        this.taskSchedulingPolicy = taskSchedulingPolicy;
        return this;
    }

    public List<UserAccount> userAccounts() {
        return this.userAccounts;
    }

    public PoolProperties withUserAccounts(List<UserAccount> userAccounts) {
        this.userAccounts = userAccounts;
        return this;
    }

    public List<MetadataItem> metadata() {
        return this.metadata;
    }

    public PoolProperties withMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public StartTask startTask() {
        return this.startTask;
    }

    public PoolProperties withStartTask(StartTask startTask) {
        this.startTask = startTask;
        return this;
    }

    public List<CertificateReference> certificates() {
        return this.certificates;
    }

    public PoolProperties withCertificates(List<CertificateReference> certificates) {
        this.certificates = certificates;
        return this;
    }

    public List<ApplicationPackageReference> applicationPackages() {
        return this.applicationPackages;
    }

    public PoolProperties withApplicationPackages(List<ApplicationPackageReference> applicationPackages) {
        this.applicationPackages = applicationPackages;
        return this;
    }

    public List<String> applicationLicenses() {
        return this.applicationLicenses;
    }

    public PoolProperties withApplicationLicenses(List<String> applicationLicenses) {
        this.applicationLicenses = applicationLicenses;
        return this;
    }

    public ResizeOperationStatus resizeOperationStatus() {
        return this.resizeOperationStatus;
    }

    public List<MountConfiguration> mountConfiguration() {
        return this.mountConfiguration;
    }

    public PoolProperties withMountConfiguration(List<MountConfiguration> mountConfiguration) {
        this.mountConfiguration = mountConfiguration;
        return this;
    }

    public NodeCommunicationMode targetNodeCommunicationMode() {
        return this.targetNodeCommunicationMode;
    }

    public PoolProperties withTargetNodeCommunicationMode(NodeCommunicationMode targetNodeCommunicationMode) {
        this.targetNodeCommunicationMode = targetNodeCommunicationMode;
        return this;
    }

    public NodeCommunicationMode currentNodeCommunicationMode() {
        return this.currentNodeCommunicationMode;
    }

    public Map<String, String> resourceTags() {
        return this.resourceTags;
    }

    public PoolProperties withResourceTags(Map<String, String> resourceTags) {
        this.resourceTags = resourceTags;
        return this;
    }

    public void validate() {
        if (this.deploymentConfiguration() != null) {
            this.deploymentConfiguration().validate();
        }
        if (this.scaleSettings() != null) {
            this.scaleSettings().validate();
        }
        if (this.autoScaleRun() != null) {
            this.autoScaleRun().validate();
        }
        if (this.networkConfiguration() != null) {
            this.networkConfiguration().validate();
        }
        if (this.taskSchedulingPolicy() != null) {
            this.taskSchedulingPolicy().validate();
        }
        if (this.userAccounts() != null) {
            this.userAccounts().forEach(e -> e.validate());
        }
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
        if (this.startTask() != null) {
            this.startTask().validate();
        }
        if (this.certificates() != null) {
            this.certificates().forEach(e -> e.validate());
        }
        if (this.applicationPackages() != null) {
            this.applicationPackages().forEach(e -> e.validate());
        }
        if (this.resizeOperationStatus() != null) {
            this.resizeOperationStatus().validate();
        }
        if (this.mountConfiguration() != null) {
            this.mountConfiguration().forEach(e -> e.validate());
        }
    }
}

