/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.models.ApplicationPackageInner;
import com.azure.resourcemanager.batch.models.ActivateApplicationPackageParameters;
import com.azure.resourcemanager.batch.models.ApplicationPackage;
import com.azure.resourcemanager.batch.models.PackageState;
import java.time.OffsetDateTime;

public final class ApplicationPackageImpl
implements ApplicationPackage,
ApplicationPackage.Definition {
    private ApplicationPackageInner innerObject;
    private final BatchManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String applicationName;
    private String versionName;

    ApplicationPackageImpl(ApplicationPackageInner innerObject, BatchManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public PackageState state() {
        return this.innerModel().state();
    }

    @Override
    public String format() {
        return this.innerModel().format();
    }

    @Override
    public String storageUrl() {
        return this.innerModel().storageUrl();
    }

    @Override
    public OffsetDateTime storageUrlExpiry() {
        return this.innerModel().storageUrlExpiry();
    }

    @Override
    public OffsetDateTime lastActivationTime() {
        return this.innerModel().lastActivationTime();
    }

    @Override
    public ApplicationPackageInner innerModel() {
        return this.innerObject;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApplicationPackageImpl withExistingApplication(String resourceGroupName, String accountName, String applicationName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.applicationName = applicationName;
        return this;
    }

    @Override
    public ApplicationPackage create() {
        this.innerObject = (ApplicationPackageInner)((Object)this.serviceManager.serviceClient().getApplicationPackages().createWithResponse(this.resourceGroupName, this.accountName, this.applicationName, this.versionName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ApplicationPackage create(Context context) {
        this.innerObject = (ApplicationPackageInner)((Object)this.serviceManager.serviceClient().getApplicationPackages().createWithResponse(this.resourceGroupName, this.accountName, this.applicationName, this.versionName, this.innerModel(), context).getValue());
        return this;
    }

    ApplicationPackageImpl(String name, BatchManager serviceManager) {
        this.innerObject = new ApplicationPackageInner();
        this.serviceManager = serviceManager;
        this.versionName = name;
    }

    @Override
    public ApplicationPackage refresh() {
        this.innerObject = (ApplicationPackageInner)((Object)this.serviceManager.serviceClient().getApplicationPackages().getWithResponse(this.resourceGroupName, this.accountName, this.applicationName, this.versionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ApplicationPackage refresh(Context context) {
        this.innerObject = (ApplicationPackageInner)((Object)this.serviceManager.serviceClient().getApplicationPackages().getWithResponse(this.resourceGroupName, this.accountName, this.applicationName, this.versionName, context).getValue());
        return this;
    }

    @Override
    public Response<ApplicationPackage> activateWithResponse(ActivateApplicationPackageParameters parameters, Context context) {
        return this.serviceManager.applicationPackages().activateWithResponse(this.resourceGroupName, this.accountName, this.applicationName, this.versionName, parameters, context);
    }

    @Override
    public ApplicationPackage activate(ActivateApplicationPackageParameters parameters) {
        return this.serviceManager.applicationPackages().activate(this.resourceGroupName, this.accountName, this.applicationName, this.versionName, parameters);
    }
}

