/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.ApplicationPackagesClient;
import com.azure.resourcemanager.batch.fluent.models.ApplicationPackageInner;
import com.azure.resourcemanager.batch.implementation.ApplicationPackageImpl;
import com.azure.resourcemanager.batch.implementation.Utils;
import com.azure.resourcemanager.batch.models.ActivateApplicationPackageParameters;
import com.azure.resourcemanager.batch.models.ApplicationPackage;
import com.azure.resourcemanager.batch.models.ApplicationPackages;

public final class ApplicationPackagesImpl
implements ApplicationPackages {
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationPackagesImpl.class);
    private final ApplicationPackagesClient innerClient;
    private final BatchManager serviceManager;

    public ApplicationPackagesImpl(ApplicationPackagesClient innerClient, BatchManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ApplicationPackage> activateWithResponse(String resourceGroupName, String accountName, String applicationName, String versionName, ActivateApplicationPackageParameters parameters, Context context) {
        Response<ApplicationPackageInner> inner = this.serviceClient().activateWithResponse(resourceGroupName, accountName, applicationName, versionName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationPackageImpl((ApplicationPackageInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ApplicationPackage activate(String resourceGroupName, String accountName, String applicationName, String versionName, ActivateApplicationPackageParameters parameters) {
        ApplicationPackageInner inner = this.serviceClient().activate(resourceGroupName, accountName, applicationName, versionName, parameters);
        if (inner != null) {
            return new ApplicationPackageImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String accountName, String applicationName, String versionName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, accountName, applicationName, versionName, context);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String applicationName, String versionName) {
        this.serviceClient().delete(resourceGroupName, accountName, applicationName, versionName);
    }

    @Override
    public Response<ApplicationPackage> getWithResponse(String resourceGroupName, String accountName, String applicationName, String versionName, Context context) {
        Response<ApplicationPackageInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, applicationName, versionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationPackageImpl((ApplicationPackageInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ApplicationPackage get(String resourceGroupName, String accountName, String applicationName, String versionName) {
        ApplicationPackageInner inner = this.serviceClient().get(resourceGroupName, accountName, applicationName, versionName);
        if (inner != null) {
            return new ApplicationPackageImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ApplicationPackage> list(String resourceGroupName, String accountName, String applicationName) {
        PagedIterable<ApplicationPackageInner> inner = this.serviceClient().list(resourceGroupName, accountName, applicationName);
        return Utils.mapPage(inner, inner1 -> new ApplicationPackageImpl((ApplicationPackageInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApplicationPackage> list(String resourceGroupName, String accountName, String applicationName, Integer maxresults, Context context) {
        PagedIterable<ApplicationPackageInner> inner = this.serviceClient().list(resourceGroupName, accountName, applicationName, maxresults, context);
        return Utils.mapPage(inner, inner1 -> new ApplicationPackageImpl((ApplicationPackageInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApplicationPackage getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String applicationName = Utils.getValueFromIdByName(id, "applications");
        if (applicationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        String versionName = Utils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return (ApplicationPackage)this.getWithResponse(resourceGroupName, accountName, applicationName, versionName, Context.NONE).getValue();
    }

    @Override
    public Response<ApplicationPackage> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String applicationName = Utils.getValueFromIdByName(id, "applications");
        if (applicationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        String versionName = Utils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, applicationName, versionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String applicationName = Utils.getValueFromIdByName(id, "applications");
        if (applicationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        String versionName = Utils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, accountName, applicationName, versionName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        String applicationName = Utils.getValueFromIdByName(id, "applications");
        if (applicationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        String versionName = Utils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, accountName, applicationName, versionName, context);
    }

    private ApplicationPackagesClient serviceClient() {
        return this.innerClient;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApplicationPackageImpl define(String name) {
        return new ApplicationPackageImpl(name, this.manager());
    }
}

