/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.models.BatchAccountInner;
import com.azure.resourcemanager.batch.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.batch.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.batch.implementation.Utils;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.AutoStorageProperties;
import com.azure.resourcemanager.batch.models.BatchAccount;
import com.azure.resourcemanager.batch.models.BatchAccountCreateParameters;
import com.azure.resourcemanager.batch.models.BatchAccountIdentity;
import com.azure.resourcemanager.batch.models.BatchAccountKeys;
import com.azure.resourcemanager.batch.models.BatchAccountRegenerateKeyParameters;
import com.azure.resourcemanager.batch.models.BatchAccountUpdateParameters;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.KeyVaultReference;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PoolAllocationMode;
import com.azure.resourcemanager.batch.models.PrivateEndpointConnection;
import com.azure.resourcemanager.batch.models.ProvisioningState;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import com.azure.resourcemanager.batch.models.VirtualMachineFamilyCoreQuota;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class BatchAccountImpl
implements BatchAccount,
BatchAccount.Definition,
BatchAccount.Update {
    private BatchAccountInner innerObject;
    private final BatchManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private BatchAccountCreateParameters createParameters;
    private BatchAccountUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public BatchAccountIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public String accountEndpoint() {
        return this.innerModel().accountEndpoint();
    }

    @Override
    public String nodeManagementEndpoint() {
        return this.innerModel().nodeManagementEndpoint();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public PoolAllocationMode poolAllocationMode() {
        return this.innerModel().poolAllocationMode();
    }

    @Override
    public KeyVaultReference keyVaultReference() {
        return this.innerModel().keyVaultReference();
    }

    @Override
    public PublicNetworkAccessType publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public NetworkProfile networkProfile() {
        return this.innerModel().networkProfile();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public AutoStorageProperties autoStorage() {
        return this.innerModel().autoStorage();
    }

    @Override
    public EncryptionProperties encryption() {
        return this.innerModel().encryption();
    }

    @Override
    public Integer dedicatedCoreQuota() {
        return this.innerModel().dedicatedCoreQuota();
    }

    @Override
    public Integer lowPriorityCoreQuota() {
        return this.innerModel().lowPriorityCoreQuota();
    }

    @Override
    public List<VirtualMachineFamilyCoreQuota> dedicatedCoreQuotaPerVMFamily() {
        List<VirtualMachineFamilyCoreQuota> inner = this.innerModel().dedicatedCoreQuotaPerVMFamily();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean dedicatedCoreQuotaPerVMFamilyEnforced() {
        return this.innerModel().dedicatedCoreQuotaPerVMFamilyEnforced();
    }

    @Override
    public Integer poolQuota() {
        return this.innerModel().poolQuota();
    }

    @Override
    public Integer activeJobAndJobScheduleQuota() {
        return this.innerModel().activeJobAndJobScheduleQuota();
    }

    @Override
    public List<AuthenticationMode> allowedAuthenticationModes() {
        List<AuthenticationMode> inner = this.innerModel().allowedAuthenticationModes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BatchAccountInner innerModel() {
        return this.innerObject;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }

    @Override
    public BatchAccountImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public BatchAccount create() {
        this.innerObject = this.serviceManager.serviceClient().getBatchAccounts().create(this.resourceGroupName, this.accountName, this.createParameters, Context.NONE);
        return this;
    }

    @Override
    public BatchAccount create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBatchAccounts().create(this.resourceGroupName, this.accountName, this.createParameters, context);
        return this;
    }

    BatchAccountImpl(String name, BatchManager serviceManager) {
        this.innerObject = new BatchAccountInner();
        this.serviceManager = serviceManager;
        this.accountName = name;
        this.createParameters = new BatchAccountCreateParameters();
    }

    @Override
    public BatchAccountImpl update() {
        this.updateParameters = new BatchAccountUpdateParameters();
        return this;
    }

    @Override
    public BatchAccount apply() {
        this.innerObject = (BatchAccountInner)((Object)this.serviceManager.serviceClient().getBatchAccounts().updateWithResponse(this.resourceGroupName, this.accountName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public BatchAccount apply(Context context) {
        this.innerObject = (BatchAccountInner)((Object)this.serviceManager.serviceClient().getBatchAccounts().updateWithResponse(this.resourceGroupName, this.accountName, this.updateParameters, context).getValue());
        return this;
    }

    BatchAccountImpl(BatchAccountInner innerObject, BatchManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = Utils.getValueFromIdByName(innerObject.id(), "batchAccounts");
    }

    @Override
    public BatchAccount refresh() {
        this.innerObject = (BatchAccountInner)((Object)this.serviceManager.serviceClient().getBatchAccounts().getByResourceGroupWithResponse(this.resourceGroupName, this.accountName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BatchAccount refresh(Context context) {
        this.innerObject = (BatchAccountInner)((Object)this.serviceManager.serviceClient().getBatchAccounts().getByResourceGroupWithResponse(this.resourceGroupName, this.accountName, context).getValue());
        return this;
    }

    @Override
    public Response<Void> synchronizeAutoStorageKeysWithResponse(Context context) {
        return this.serviceManager.batchAccounts().synchronizeAutoStorageKeysWithResponse(this.resourceGroupName, this.accountName, context);
    }

    @Override
    public void synchronizeAutoStorageKeys() {
        this.serviceManager.batchAccounts().synchronizeAutoStorageKeys(this.resourceGroupName, this.accountName);
    }

    @Override
    public Response<BatchAccountKeys> regenerateKeyWithResponse(BatchAccountRegenerateKeyParameters parameters, Context context) {
        return this.serviceManager.batchAccounts().regenerateKeyWithResponse(this.resourceGroupName, this.accountName, parameters, context);
    }

    @Override
    public BatchAccountKeys regenerateKey(BatchAccountRegenerateKeyParameters parameters) {
        return this.serviceManager.batchAccounts().regenerateKey(this.resourceGroupName, this.accountName, parameters);
    }

    @Override
    public Response<BatchAccountKeys> getKeysWithResponse(Context context) {
        return this.serviceManager.batchAccounts().getKeysWithResponse(this.resourceGroupName, this.accountName, context);
    }

    @Override
    public BatchAccountKeys getKeys() {
        return this.serviceManager.batchAccounts().getKeys(this.resourceGroupName, this.accountName);
    }

    @Override
    public BatchAccountImpl withRegion(Region location) {
        this.createParameters.withLocation(location.toString());
        return this;
    }

    @Override
    public BatchAccountImpl withRegion(String location) {
        this.createParameters.withLocation(location);
        return this;
    }

    @Override
    public BatchAccountImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.createParameters.withTags(tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public BatchAccountImpl withIdentity(BatchAccountIdentity identity) {
        if (this.isInCreateMode()) {
            this.createParameters.withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public BatchAccountImpl withAutoStorage(AutoStorageBaseProperties autoStorage) {
        if (this.isInCreateMode()) {
            this.createParameters.withAutoStorage(autoStorage);
            return this;
        }
        this.updateParameters.withAutoStorage(autoStorage);
        return this;
    }

    @Override
    public BatchAccountImpl withPoolAllocationMode(PoolAllocationMode poolAllocationMode) {
        this.createParameters.withPoolAllocationMode(poolAllocationMode);
        return this;
    }

    @Override
    public BatchAccountImpl withKeyVaultReference(KeyVaultReference keyVaultReference) {
        this.createParameters.withKeyVaultReference(keyVaultReference);
        return this;
    }

    @Override
    public BatchAccountImpl withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.createParameters.withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public BatchAccountImpl withNetworkProfile(NetworkProfile networkProfile) {
        if (this.isInCreateMode()) {
            this.createParameters.withNetworkProfile(networkProfile);
            return this;
        }
        this.updateParameters.withNetworkProfile(networkProfile);
        return this;
    }

    @Override
    public BatchAccountImpl withEncryption(EncryptionProperties encryption) {
        if (this.isInCreateMode()) {
            this.createParameters.withEncryption(encryption);
            return this;
        }
        this.updateParameters.withEncryption(encryption);
        return this;
    }

    @Override
    public BatchAccountImpl withAllowedAuthenticationModes(List<AuthenticationMode> allowedAuthenticationModes) {
        if (this.isInCreateMode()) {
            this.createParameters.withAllowedAuthenticationModes(allowedAuthenticationModes);
            return this;
        }
        this.updateParameters.withAllowedAuthenticationModes(allowedAuthenticationModes);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

