/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.BatchAccountsClient;
import com.azure.resourcemanager.batch.fluent.models.BatchAccountInner;
import com.azure.resourcemanager.batch.fluent.models.BatchAccountKeysInner;
import com.azure.resourcemanager.batch.fluent.models.DetectorResponseInner;
import com.azure.resourcemanager.batch.fluent.models.OutboundEnvironmentEndpointInner;
import com.azure.resourcemanager.batch.implementation.BatchAccountImpl;
import com.azure.resourcemanager.batch.implementation.BatchAccountKeysImpl;
import com.azure.resourcemanager.batch.implementation.DetectorResponseImpl;
import com.azure.resourcemanager.batch.implementation.OutboundEnvironmentEndpointImpl;
import com.azure.resourcemanager.batch.implementation.Utils;
import com.azure.resourcemanager.batch.models.BatchAccount;
import com.azure.resourcemanager.batch.models.BatchAccountKeys;
import com.azure.resourcemanager.batch.models.BatchAccountRegenerateKeyParameters;
import com.azure.resourcemanager.batch.models.BatchAccounts;
import com.azure.resourcemanager.batch.models.DetectorResponse;
import com.azure.resourcemanager.batch.models.OutboundEnvironmentEndpoint;

public final class BatchAccountsImpl
implements BatchAccounts {
    private static final ClientLogger LOGGER = new ClientLogger(BatchAccountsImpl.class);
    private final BatchAccountsClient innerClient;
    private final BatchManager serviceManager;

    public BatchAccountsImpl(BatchAccountsClient innerClient, BatchManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String accountName) {
        this.serviceClient().delete(resourceGroupName, accountName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, context);
    }

    @Override
    public Response<BatchAccount> getByResourceGroupWithResponse(String resourceGroupName, String accountName, Context context) {
        Response<BatchAccountInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, accountName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BatchAccountImpl((BatchAccountInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BatchAccount getByResourceGroup(String resourceGroupName, String accountName) {
        BatchAccountInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, accountName);
        if (inner != null) {
            return new BatchAccountImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<BatchAccount> list() {
        PagedIterable<BatchAccountInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new BatchAccountImpl((BatchAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BatchAccount> list(Context context) {
        PagedIterable<BatchAccountInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new BatchAccountImpl((BatchAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BatchAccount> listByResourceGroup(String resourceGroupName) {
        PagedIterable<BatchAccountInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new BatchAccountImpl((BatchAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BatchAccount> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<BatchAccountInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new BatchAccountImpl((BatchAccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Void> synchronizeAutoStorageKeysWithResponse(String resourceGroupName, String accountName, Context context) {
        return this.serviceClient().synchronizeAutoStorageKeysWithResponse(resourceGroupName, accountName, context);
    }

    @Override
    public void synchronizeAutoStorageKeys(String resourceGroupName, String accountName) {
        this.serviceClient().synchronizeAutoStorageKeys(resourceGroupName, accountName);
    }

    @Override
    public Response<BatchAccountKeys> regenerateKeyWithResponse(String resourceGroupName, String accountName, BatchAccountRegenerateKeyParameters parameters, Context context) {
        Response<BatchAccountKeysInner> inner = this.serviceClient().regenerateKeyWithResponse(resourceGroupName, accountName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BatchAccountKeysImpl((BatchAccountKeysInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public BatchAccountKeys regenerateKey(String resourceGroupName, String accountName, BatchAccountRegenerateKeyParameters parameters) {
        BatchAccountKeysInner inner = this.serviceClient().regenerateKey(resourceGroupName, accountName, parameters);
        if (inner != null) {
            return new BatchAccountKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<BatchAccountKeys> getKeysWithResponse(String resourceGroupName, String accountName, Context context) {
        Response<BatchAccountKeysInner> inner = this.serviceClient().getKeysWithResponse(resourceGroupName, accountName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BatchAccountKeysImpl((BatchAccountKeysInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public BatchAccountKeys getKeys(String resourceGroupName, String accountName) {
        BatchAccountKeysInner inner = this.serviceClient().getKeys(resourceGroupName, accountName);
        if (inner != null) {
            return new BatchAccountKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<DetectorResponse> listDetectors(String resourceGroupName, String accountName) {
        PagedIterable<DetectorResponseInner> inner = this.serviceClient().listDetectors(resourceGroupName, accountName);
        return Utils.mapPage(inner, inner1 -> new DetectorResponseImpl((DetectorResponseInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DetectorResponse> listDetectors(String resourceGroupName, String accountName, Context context) {
        PagedIterable<DetectorResponseInner> inner = this.serviceClient().listDetectors(resourceGroupName, accountName, context);
        return Utils.mapPage(inner, inner1 -> new DetectorResponseImpl((DetectorResponseInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DetectorResponse> getDetectorWithResponse(String resourceGroupName, String accountName, String detectorId, Context context) {
        Response<DetectorResponseInner> inner = this.serviceClient().getDetectorWithResponse(resourceGroupName, accountName, detectorId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DetectorResponseImpl((DetectorResponseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DetectorResponse getDetector(String resourceGroupName, String accountName, String detectorId) {
        DetectorResponseInner inner = this.serviceClient().getDetector(resourceGroupName, accountName, detectorId);
        if (inner != null) {
            return new DetectorResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<OutboundEnvironmentEndpoint> listOutboundNetworkDependenciesEndpoints(String resourceGroupName, String accountName) {
        PagedIterable<OutboundEnvironmentEndpointInner> inner = this.serviceClient().listOutboundNetworkDependenciesEndpoints(resourceGroupName, accountName);
        return Utils.mapPage(inner, inner1 -> new OutboundEnvironmentEndpointImpl((OutboundEnvironmentEndpointInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<OutboundEnvironmentEndpoint> listOutboundNetworkDependenciesEndpoints(String resourceGroupName, String accountName, Context context) {
        PagedIterable<OutboundEnvironmentEndpointInner> inner = this.serviceClient().listOutboundNetworkDependenciesEndpoints(resourceGroupName, accountName, context);
        return Utils.mapPage(inner, inner1 -> new OutboundEnvironmentEndpointImpl((OutboundEnvironmentEndpointInner)inner1, this.manager()));
    }

    @Override
    public BatchAccount getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        return (BatchAccount)this.getByResourceGroupWithResponse(resourceGroupName, accountName, Context.NONE).getValue();
    }

    @Override
    public Response<BatchAccount> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, accountName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        this.delete(resourceGroupName, accountName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = Utils.getValueFromIdByName(id, "batchAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'batchAccounts'.", id)));
        }
        this.delete(resourceGroupName, accountName, context);
    }

    private BatchAccountsClient serviceClient() {
        return this.innerClient;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }

    @Override
    public BatchAccountImpl define(String name) {
        return new BatchAccountImpl(name, this.manager());
    }
}

