/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.models.CertificateInner;
import com.azure.resourcemanager.batch.implementation.Utils;
import com.azure.resourcemanager.batch.models.Certificate;
import com.azure.resourcemanager.batch.models.CertificateCreateOrUpdateParameters;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import com.azure.resourcemanager.batch.models.CertificateProvisioningState;
import com.azure.resourcemanager.batch.models.DeleteCertificateError;
import java.time.OffsetDateTime;

public final class CertificateImpl
implements Certificate,
Certificate.Definition,
Certificate.Update {
    private CertificateInner innerObject;
    private final BatchManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String certificateName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private CertificateCreateOrUpdateParameters createParameters;
    private String updateIfMatch;
    private CertificateCreateOrUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public CertificateProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public OffsetDateTime provisioningStateTransitionTime() {
        return this.innerModel().provisioningStateTransitionTime();
    }

    @Override
    public CertificateProvisioningState previousProvisioningState() {
        return this.innerModel().previousProvisioningState();
    }

    @Override
    public OffsetDateTime previousProvisioningStateTransitionTime() {
        return this.innerModel().previousProvisioningStateTransitionTime();
    }

    @Override
    public String publicData() {
        return this.innerModel().publicData();
    }

    @Override
    public DeleteCertificateError deleteCertificateError() {
        return this.innerModel().deleteCertificateError();
    }

    @Override
    public String thumbprintAlgorithm() {
        return this.innerModel().thumbprintAlgorithm();
    }

    @Override
    public String thumbprint() {
        return this.innerModel().thumbprint();
    }

    @Override
    public CertificateFormat format() {
        return this.innerModel().format();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CertificateInner innerModel() {
        return this.innerObject;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }

    @Override
    public CertificateImpl withExistingBatchAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public Certificate create() {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().createWithResponse(this.resourceGroupName, this.accountName, this.certificateName, this.createParameters, this.createIfMatch, this.createIfNoneMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public Certificate create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().createWithResponse(this.resourceGroupName, this.accountName, this.certificateName, this.createParameters, this.createIfMatch, this.createIfNoneMatch, context).getValue();
        return this;
    }

    CertificateImpl(String name, BatchManager serviceManager) {
        this.innerObject = new CertificateInner();
        this.serviceManager = serviceManager;
        this.certificateName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
        this.createParameters = new CertificateCreateOrUpdateParameters();
    }

    @Override
    public CertificateImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new CertificateCreateOrUpdateParameters();
        return this;
    }

    @Override
    public Certificate apply() {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().updateWithResponse(this.resourceGroupName, this.accountName, this.certificateName, this.updateParameters, this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public Certificate apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().updateWithResponse(this.resourceGroupName, this.accountName, this.certificateName, this.updateParameters, this.updateIfMatch, context).getValue();
        return this;
    }

    CertificateImpl(CertificateInner innerObject, BatchManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = Utils.getValueFromIdByName(innerObject.id(), "batchAccounts");
        this.certificateName = Utils.getValueFromIdByName(innerObject.id(), "certificates");
    }

    @Override
    public Certificate refresh() {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().getWithResponse(this.resourceGroupName, this.accountName, this.certificateName, Context.NONE).getValue();
        return this;
    }

    @Override
    public Certificate refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().getWithResponse(this.resourceGroupName, this.accountName, this.certificateName, context).getValue();
        return this;
    }

    @Override
    public Response<Certificate> cancelDeletionWithResponse(Context context) {
        return this.serviceManager.certificates().cancelDeletionWithResponse(this.resourceGroupName, this.accountName, this.certificateName, context);
    }

    @Override
    public Certificate cancelDeletion() {
        return this.serviceManager.certificates().cancelDeletion(this.resourceGroupName, this.accountName, this.certificateName);
    }

    @Override
    public CertificateImpl withPassword(String password) {
        if (this.isInCreateMode()) {
            this.createParameters.withPassword(password);
            return this;
        }
        this.updateParameters.withPassword(password);
        return this;
    }

    @Override
    public CertificateImpl withThumbprintAlgorithm(String thumbprintAlgorithm) {
        if (this.isInCreateMode()) {
            this.createParameters.withThumbprintAlgorithm(thumbprintAlgorithm);
            return this;
        }
        this.updateParameters.withThumbprintAlgorithm(thumbprintAlgorithm);
        return this;
    }

    @Override
    public CertificateImpl withThumbprint(String thumbprint) {
        if (this.isInCreateMode()) {
            this.createParameters.withThumbprint(thumbprint);
            return this;
        }
        this.updateParameters.withThumbprint(thumbprint);
        return this;
    }

    @Override
    public CertificateImpl withFormat(CertificateFormat format) {
        if (this.isInCreateMode()) {
            this.createParameters.withFormat(format);
            return this;
        }
        this.updateParameters.withFormat(format);
        return this;
    }

    @Override
    public CertificateImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public CertificateImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    @Override
    public CertificateImpl withData(String data) {
        this.updateParameters.withData(data);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

