/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.batch.fluent.LocationsClient;
import com.azure.resourcemanager.batch.fluent.models.BatchLocationQuotaInner;
import com.azure.resourcemanager.batch.fluent.models.CheckNameAvailabilityResultInner;
import com.azure.resourcemanager.batch.fluent.models.SupportedSkuInner;
import com.azure.resourcemanager.batch.implementation.BatchManagementClientImpl;
import com.azure.resourcemanager.batch.models.CheckNameAvailabilityParameters;
import com.azure.resourcemanager.batch.models.SupportedSkusResult;
import reactor.core.publisher.Mono;

public final class LocationsClientImpl
implements LocationsClient {
    private final LocationsService service;
    private final BatchManagementClientImpl client;

    LocationsClientImpl(BatchManagementClientImpl client) {
        this.service = (LocationsService)RestProxy.create(LocationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BatchLocationQuotaInner>> getQuotasWithResponseAsync(String locationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getQuotas(this.client.getEndpoint(), locationName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BatchLocationQuotaInner>> getQuotasWithResponseAsync(String locationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getQuotas(this.client.getEndpoint(), locationName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BatchLocationQuotaInner> getQuotasAsync(String locationName) {
        return this.getQuotasWithResponseAsync(locationName).flatMap(res -> Mono.justOrEmpty((Object)((BatchLocationQuotaInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BatchLocationQuotaInner> getQuotasWithResponse(String locationName, Context context) {
        return (Response)this.getQuotasWithResponseAsync(locationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchLocationQuotaInner getQuotas(String locationName) {
        return (BatchLocationQuotaInner)this.getQuotasWithResponse(locationName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SupportedSkuInner>> listSupportedVirtualMachineSkusSinglePageAsync(String locationName, Integer maxresults, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSupportedVirtualMachineSkus(this.client.getEndpoint(), locationName, maxresults, filter, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SupportedSkusResult)res.getValue()).value(), ((SupportedSkusResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SupportedSkuInner>> listSupportedVirtualMachineSkusSinglePageAsync(String locationName, Integer maxresults, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSupportedVirtualMachineSkus(this.client.getEndpoint(), locationName, maxresults, filter, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SupportedSkusResult)res.getValue()).value(), ((SupportedSkusResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SupportedSkuInner> listSupportedVirtualMachineSkusAsync(String locationName, Integer maxresults, String filter) {
        return new PagedFlux(() -> this.listSupportedVirtualMachineSkusSinglePageAsync(locationName, maxresults, filter), nextLink -> this.listSupportedVirtualMachineSkusNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SupportedSkuInner> listSupportedVirtualMachineSkusAsync(String locationName) {
        Integer maxresults = null;
        String filter = null;
        return new PagedFlux(() -> this.listSupportedVirtualMachineSkusSinglePageAsync(locationName, maxresults, filter), nextLink -> this.listSupportedVirtualMachineSkusNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SupportedSkuInner> listSupportedVirtualMachineSkusAsync(String locationName, Integer maxresults, String filter, Context context) {
        return new PagedFlux(() -> this.listSupportedVirtualMachineSkusSinglePageAsync(locationName, maxresults, filter, context), nextLink -> this.listSupportedVirtualMachineSkusNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SupportedSkuInner> listSupportedVirtualMachineSkus(String locationName) {
        Integer maxresults = null;
        String filter = null;
        return new PagedIterable(this.listSupportedVirtualMachineSkusAsync(locationName, maxresults, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SupportedSkuInner> listSupportedVirtualMachineSkus(String locationName, Integer maxresults, String filter, Context context) {
        return new PagedIterable(this.listSupportedVirtualMachineSkusAsync(locationName, maxresults, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SupportedSkuInner>> listSupportedCloudServiceSkusSinglePageAsync(String locationName, Integer maxresults, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSupportedCloudServiceSkus(this.client.getEndpoint(), locationName, maxresults, filter, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SupportedSkusResult)res.getValue()).value(), ((SupportedSkusResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SupportedSkuInner>> listSupportedCloudServiceSkusSinglePageAsync(String locationName, Integer maxresults, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSupportedCloudServiceSkus(this.client.getEndpoint(), locationName, maxresults, filter, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SupportedSkusResult)res.getValue()).value(), ((SupportedSkusResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SupportedSkuInner> listSupportedCloudServiceSkusAsync(String locationName, Integer maxresults, String filter) {
        return new PagedFlux(() -> this.listSupportedCloudServiceSkusSinglePageAsync(locationName, maxresults, filter), nextLink -> this.listSupportedCloudServiceSkusNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SupportedSkuInner> listSupportedCloudServiceSkusAsync(String locationName) {
        Integer maxresults = null;
        String filter = null;
        return new PagedFlux(() -> this.listSupportedCloudServiceSkusSinglePageAsync(locationName, maxresults, filter), nextLink -> this.listSupportedCloudServiceSkusNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SupportedSkuInner> listSupportedCloudServiceSkusAsync(String locationName, Integer maxresults, String filter, Context context) {
        return new PagedFlux(() -> this.listSupportedCloudServiceSkusSinglePageAsync(locationName, maxresults, filter, context), nextLink -> this.listSupportedCloudServiceSkusNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SupportedSkuInner> listSupportedCloudServiceSkus(String locationName) {
        Integer maxresults = null;
        String filter = null;
        return new PagedIterable(this.listSupportedCloudServiceSkusAsync(locationName, maxresults, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SupportedSkuInner> listSupportedCloudServiceSkus(String locationName, Integer maxresults, String filter, Context context) {
        return new PagedIterable(this.listSupportedCloudServiceSkusAsync(locationName, maxresults, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithResponseAsync(String locationName, CheckNameAvailabilityParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkNameAvailability(this.client.getEndpoint(), locationName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithResponseAsync(String locationName, CheckNameAvailabilityParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkNameAvailability(this.client.getEndpoint(), locationName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String locationName, CheckNameAvailabilityParameters parameters) {
        return this.checkNameAvailabilityWithResponseAsync(locationName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((CheckNameAvailabilityResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckNameAvailabilityResultInner> checkNameAvailabilityWithResponse(String locationName, CheckNameAvailabilityParameters parameters, Context context) {
        return (Response)this.checkNameAvailabilityWithResponseAsync(locationName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckNameAvailabilityResultInner checkNameAvailability(String locationName, CheckNameAvailabilityParameters parameters) {
        return (CheckNameAvailabilityResultInner)this.checkNameAvailabilityWithResponse(locationName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SupportedSkuInner>> listSupportedVirtualMachineSkusNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSupportedVirtualMachineSkusNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SupportedSkusResult)res.getValue()).value(), ((SupportedSkusResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SupportedSkuInner>> listSupportedVirtualMachineSkusNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSupportedVirtualMachineSkusNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SupportedSkusResult)res.getValue()).value(), ((SupportedSkusResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SupportedSkuInner>> listSupportedCloudServiceSkusNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSupportedCloudServiceSkusNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SupportedSkusResult)res.getValue()).value(), ((SupportedSkusResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SupportedSkuInner>> listSupportedCloudServiceSkusNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSupportedCloudServiceSkusNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SupportedSkusResult)res.getValue()).value(), ((SupportedSkusResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="BatchManagementClien")
    public static interface LocationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/quotas")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BatchLocationQuotaInner>> getQuotas(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/virtualMachineSkus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SupportedSkusResult>> listSupportedVirtualMachineSkus(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="$filter") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/cloudServiceSkus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SupportedSkusResult>> listSupportedCloudServiceSkus(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="$filter") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailability(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") CheckNameAvailabilityParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SupportedSkusResult>> listSupportedVirtualMachineSkusNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SupportedSkusResult>> listSupportedCloudServiceSkusNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

