/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.batch.BatchManager;
import com.azure.resourcemanager.batch.fluent.models.PoolInner;
import com.azure.resourcemanager.batch.implementation.Utils;
import com.azure.resourcemanager.batch.models.AllocationState;
import com.azure.resourcemanager.batch.models.ApplicationPackageReference;
import com.azure.resourcemanager.batch.models.AutoScaleRun;
import com.azure.resourcemanager.batch.models.BatchPoolIdentity;
import com.azure.resourcemanager.batch.models.CertificateReference;
import com.azure.resourcemanager.batch.models.DeploymentConfiguration;
import com.azure.resourcemanager.batch.models.InterNodeCommunicationState;
import com.azure.resourcemanager.batch.models.MetadataItem;
import com.azure.resourcemanager.batch.models.MountConfiguration;
import com.azure.resourcemanager.batch.models.NetworkConfiguration;
import com.azure.resourcemanager.batch.models.NodeCommunicationMode;
import com.azure.resourcemanager.batch.models.Pool;
import com.azure.resourcemanager.batch.models.PoolProvisioningState;
import com.azure.resourcemanager.batch.models.ResizeOperationStatus;
import com.azure.resourcemanager.batch.models.ScaleSettings;
import com.azure.resourcemanager.batch.models.StartTask;
import com.azure.resourcemanager.batch.models.TaskSchedulingPolicy;
import com.azure.resourcemanager.batch.models.UserAccount;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class PoolImpl
implements Pool,
Pool.Definition,
Pool.Update {
    private PoolInner innerObject;
    private final BatchManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public BatchPoolIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public OffsetDateTime lastModified() {
        return this.innerModel().lastModified();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public PoolProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public OffsetDateTime provisioningStateTransitionTime() {
        return this.innerModel().provisioningStateTransitionTime();
    }

    @Override
    public AllocationState allocationState() {
        return this.innerModel().allocationState();
    }

    @Override
    public OffsetDateTime allocationStateTransitionTime() {
        return this.innerModel().allocationStateTransitionTime();
    }

    @Override
    public String vmSize() {
        return this.innerModel().vmSize();
    }

    @Override
    public DeploymentConfiguration deploymentConfiguration() {
        return this.innerModel().deploymentConfiguration();
    }

    @Override
    public Integer currentDedicatedNodes() {
        return this.innerModel().currentDedicatedNodes();
    }

    @Override
    public Integer currentLowPriorityNodes() {
        return this.innerModel().currentLowPriorityNodes();
    }

    @Override
    public ScaleSettings scaleSettings() {
        return this.innerModel().scaleSettings();
    }

    @Override
    public AutoScaleRun autoScaleRun() {
        return this.innerModel().autoScaleRun();
    }

    @Override
    public InterNodeCommunicationState interNodeCommunication() {
        return this.innerModel().interNodeCommunication();
    }

    @Override
    public NetworkConfiguration networkConfiguration() {
        return this.innerModel().networkConfiguration();
    }

    @Override
    public Integer taskSlotsPerNode() {
        return this.innerModel().taskSlotsPerNode();
    }

    @Override
    public TaskSchedulingPolicy taskSchedulingPolicy() {
        return this.innerModel().taskSchedulingPolicy();
    }

    @Override
    public List<UserAccount> userAccounts() {
        List<UserAccount> inner = this.innerModel().userAccounts();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<MetadataItem> metadata() {
        List<MetadataItem> inner = this.innerModel().metadata();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public StartTask startTask() {
        return this.innerModel().startTask();
    }

    @Override
    public List<CertificateReference> certificates() {
        List<CertificateReference> inner = this.innerModel().certificates();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ApplicationPackageReference> applicationPackages() {
        List<ApplicationPackageReference> inner = this.innerModel().applicationPackages();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> applicationLicenses() {
        List<String> inner = this.innerModel().applicationLicenses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ResizeOperationStatus resizeOperationStatus() {
        return this.innerModel().resizeOperationStatus();
    }

    @Override
    public List<MountConfiguration> mountConfiguration() {
        List<MountConfiguration> inner = this.innerModel().mountConfiguration();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public NodeCommunicationMode targetNodeCommunicationMode() {
        return this.innerModel().targetNodeCommunicationMode();
    }

    @Override
    public NodeCommunicationMode currentNodeCommunicationMode() {
        return this.innerModel().currentNodeCommunicationMode();
    }

    @Override
    public Map<String, String> resourceTags() {
        Map<String, String> inner = this.innerModel().resourceTags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PoolInner innerModel() {
        return this.innerObject;
    }

    private BatchManager manager() {
        return this.serviceManager;
    }

    @Override
    public PoolImpl withExistingBatchAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public Pool create() {
        this.innerObject = this.serviceManager.serviceClient().getPools().createWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public Pool create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPools().createWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context).getValue();
        return this;
    }

    PoolImpl(String name, BatchManager serviceManager) {
        this.innerObject = new PoolInner();
        this.serviceManager = serviceManager;
        this.poolName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public PoolImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public Pool apply() {
        this.innerObject = this.serviceManager.serviceClient().getPools().updateWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public Pool apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPools().updateWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    PoolImpl(PoolInner innerObject, BatchManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = Utils.getValueFromIdByName(innerObject.id(), "batchAccounts");
        this.poolName = Utils.getValueFromIdByName(innerObject.id(), "pools");
    }

    @Override
    public Pool refresh() {
        this.innerObject = this.serviceManager.serviceClient().getPools().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, Context.NONE).getValue();
        return this;
    }

    @Override
    public Pool refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPools().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, context).getValue();
        return this;
    }

    @Override
    public Response<Pool> disableAutoScaleWithResponse(Context context) {
        return this.serviceManager.pools().disableAutoScaleWithResponse(this.resourceGroupName, this.accountName, this.poolName, context);
    }

    @Override
    public Pool disableAutoScale() {
        return this.serviceManager.pools().disableAutoScale(this.resourceGroupName, this.accountName, this.poolName);
    }

    @Override
    public Response<Pool> stopResizeWithResponse(Context context) {
        return this.serviceManager.pools().stopResizeWithResponse(this.resourceGroupName, this.accountName, this.poolName, context);
    }

    @Override
    public Pool stopResize() {
        return this.serviceManager.pools().stopResize(this.resourceGroupName, this.accountName, this.poolName);
    }

    @Override
    public PoolImpl withIdentity(BatchPoolIdentity identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    @Override
    public PoolImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public PoolImpl withVmSize(String vmSize) {
        this.innerModel().withVmSize(vmSize);
        return this;
    }

    @Override
    public PoolImpl withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.innerModel().withDeploymentConfiguration(deploymentConfiguration);
        return this;
    }

    @Override
    public PoolImpl withScaleSettings(ScaleSettings scaleSettings) {
        this.innerModel().withScaleSettings(scaleSettings);
        return this;
    }

    @Override
    public PoolImpl withInterNodeCommunication(InterNodeCommunicationState interNodeCommunication) {
        this.innerModel().withInterNodeCommunication(interNodeCommunication);
        return this;
    }

    @Override
    public PoolImpl withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.innerModel().withNetworkConfiguration(networkConfiguration);
        return this;
    }

    @Override
    public PoolImpl withTaskSlotsPerNode(Integer taskSlotsPerNode) {
        this.innerModel().withTaskSlotsPerNode(taskSlotsPerNode);
        return this;
    }

    @Override
    public PoolImpl withTaskSchedulingPolicy(TaskSchedulingPolicy taskSchedulingPolicy) {
        this.innerModel().withTaskSchedulingPolicy(taskSchedulingPolicy);
        return this;
    }

    @Override
    public PoolImpl withUserAccounts(List<UserAccount> userAccounts) {
        this.innerModel().withUserAccounts(userAccounts);
        return this;
    }

    @Override
    public PoolImpl withMetadata(List<MetadataItem> metadata) {
        this.innerModel().withMetadata(metadata);
        return this;
    }

    @Override
    public PoolImpl withStartTask(StartTask startTask) {
        this.innerModel().withStartTask(startTask);
        return this;
    }

    @Override
    public PoolImpl withCertificates(List<CertificateReference> certificates) {
        this.innerModel().withCertificates(certificates);
        return this;
    }

    @Override
    public PoolImpl withApplicationPackages(List<ApplicationPackageReference> applicationPackages) {
        this.innerModel().withApplicationPackages(applicationPackages);
        return this;
    }

    @Override
    public PoolImpl withApplicationLicenses(List<String> applicationLicenses) {
        this.innerModel().withApplicationLicenses(applicationLicenses);
        return this;
    }

    @Override
    public PoolImpl withMountConfiguration(List<MountConfiguration> mountConfiguration) {
        this.innerModel().withMountConfiguration(mountConfiguration);
        return this;
    }

    @Override
    public PoolImpl withTargetNodeCommunicationMode(NodeCommunicationMode targetNodeCommunicationMode) {
        this.innerModel().withTargetNodeCommunicationMode(targetNodeCommunicationMode);
        return this;
    }

    @Override
    public PoolImpl withResourceTags(Map<String, String> resourceTags) {
        this.innerModel().withResourceTags(resourceTags);
        return this;
    }

    @Override
    public PoolImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public PoolImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

