/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.AutoScaleRunError;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class AutoScaleRun {
    @JsonProperty(value="evaluationTime", required=true)
    private OffsetDateTime evaluationTime;
    @JsonProperty(value="results")
    private String results;
    @JsonProperty(value="error")
    private AutoScaleRunError error;
    private static final ClientLogger LOGGER = new ClientLogger(AutoScaleRun.class);

    public OffsetDateTime evaluationTime() {
        return this.evaluationTime;
    }

    public AutoScaleRun withEvaluationTime(OffsetDateTime evaluationTime) {
        this.evaluationTime = evaluationTime;
        return this;
    }

    public String results() {
        return this.results;
    }

    public AutoScaleRun withResults(String results) {
        this.results = results;
        return this;
    }

    public AutoScaleRunError error() {
        return this.error;
    }

    public AutoScaleRun withError(AutoScaleRunError error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.evaluationTime() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property evaluationTime in model AutoScaleRun"));
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }
}

