/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.AutoStorageAuthenticationMode;
import com.azure.resourcemanager.batch.models.ComputeNodeIdentityReference;
import com.fasterxml.jackson.annotation.JsonProperty;

public class AutoStorageBaseProperties {
    @JsonProperty(value="storageAccountId", required=true)
    private String storageAccountId;
    @JsonProperty(value="authenticationMode")
    private AutoStorageAuthenticationMode authenticationMode;
    @JsonProperty(value="nodeIdentityReference")
    private ComputeNodeIdentityReference nodeIdentityReference;
    private static final ClientLogger LOGGER = new ClientLogger(AutoStorageBaseProperties.class);

    public String storageAccountId() {
        return this.storageAccountId;
    }

    public AutoStorageBaseProperties withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    public AutoStorageAuthenticationMode authenticationMode() {
        return this.authenticationMode;
    }

    public AutoStorageBaseProperties withAuthenticationMode(AutoStorageAuthenticationMode authenticationMode) {
        this.authenticationMode = authenticationMode;
        return this;
    }

    public ComputeNodeIdentityReference nodeIdentityReference() {
        return this.nodeIdentityReference;
    }

    public AutoStorageBaseProperties withNodeIdentityReference(ComputeNodeIdentityReference nodeIdentityReference) {
        this.nodeIdentityReference = nodeIdentityReference;
        return this;
    }

    public void validate() {
        if (this.storageAccountId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageAccountId in model AutoStorageBaseProperties"));
        }
        if (this.nodeIdentityReference() != null) {
            this.nodeIdentityReference().validate();
        }
    }
}

