/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.AutoStorageAuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.ComputeNodeIdentityReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class AutoStorageProperties
extends AutoStorageBaseProperties {
    @JsonProperty(value="lastKeySync", required=true)
    private OffsetDateTime lastKeySync;
    private static final ClientLogger LOGGER = new ClientLogger(AutoStorageProperties.class);

    public OffsetDateTime lastKeySync() {
        return this.lastKeySync;
    }

    public AutoStorageProperties withLastKeySync(OffsetDateTime lastKeySync) {
        this.lastKeySync = lastKeySync;
        return this;
    }

    @Override
    public AutoStorageProperties withStorageAccountId(String storageAccountId) {
        super.withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public AutoStorageProperties withAuthenticationMode(AutoStorageAuthenticationMode authenticationMode) {
        super.withAuthenticationMode(authenticationMode);
        return this;
    }

    @Override
    public AutoStorageProperties withNodeIdentityReference(ComputeNodeIdentityReference nodeIdentityReference) {
        super.withNodeIdentityReference(nodeIdentityReference);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.lastKeySync() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property lastKeySync in model AutoStorageProperties"));
        }
    }
}

