/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.ComputeNodeIdentityReference;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class AzureBlobFileSystemConfiguration {
    @JsonProperty(value="accountName", required=true)
    private String accountName;
    @JsonProperty(value="containerName", required=true)
    private String containerName;
    @JsonProperty(value="accountKey")
    private String accountKey;
    @JsonProperty(value="sasKey")
    private String sasKey;
    @JsonProperty(value="blobfuseOptions")
    private String blobfuseOptions;
    @JsonProperty(value="relativeMountPath", required=true)
    private String relativeMountPath;
    @JsonProperty(value="identityReference")
    private ComputeNodeIdentityReference identityReference;
    private static final ClientLogger LOGGER = new ClientLogger(AzureBlobFileSystemConfiguration.class);

    public String accountName() {
        return this.accountName;
    }

    public AzureBlobFileSystemConfiguration withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String containerName() {
        return this.containerName;
    }

    public AzureBlobFileSystemConfiguration withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public String accountKey() {
        return this.accountKey;
    }

    public AzureBlobFileSystemConfiguration withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public String sasKey() {
        return this.sasKey;
    }

    public AzureBlobFileSystemConfiguration withSasKey(String sasKey) {
        this.sasKey = sasKey;
        return this;
    }

    public String blobfuseOptions() {
        return this.blobfuseOptions;
    }

    public AzureBlobFileSystemConfiguration withBlobfuseOptions(String blobfuseOptions) {
        this.blobfuseOptions = blobfuseOptions;
        return this;
    }

    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    public AzureBlobFileSystemConfiguration withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    public ComputeNodeIdentityReference identityReference() {
        return this.identityReference;
    }

    public AzureBlobFileSystemConfiguration withIdentityReference(ComputeNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    public void validate() {
        if (this.accountName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property accountName in model AzureBlobFileSystemConfiguration"));
        }
        if (this.containerName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property containerName in model AzureBlobFileSystemConfiguration"));
        }
        if (this.relativeMountPath() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property relativeMountPath in model AzureBlobFileSystemConfiguration"));
        }
        if (this.identityReference() != null) {
            this.identityReference().validate();
        }
    }
}

