/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.batch.fluent.models.BatchAccountInner;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.AutoStorageProperties;
import com.azure.resourcemanager.batch.models.BatchAccountIdentity;
import com.azure.resourcemanager.batch.models.BatchAccountKeys;
import com.azure.resourcemanager.batch.models.BatchAccountRegenerateKeyParameters;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.KeyVaultReference;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PoolAllocationMode;
import com.azure.resourcemanager.batch.models.PrivateEndpointConnection;
import com.azure.resourcemanager.batch.models.ProvisioningState;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import com.azure.resourcemanager.batch.models.VirtualMachineFamilyCoreQuota;
import java.util.List;
import java.util.Map;

public interface BatchAccount {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public BatchAccountIdentity identity();

    public String accountEndpoint();

    public String nodeManagementEndpoint();

    public ProvisioningState provisioningState();

    public PoolAllocationMode poolAllocationMode();

    public KeyVaultReference keyVaultReference();

    public PublicNetworkAccessType publicNetworkAccess();

    public NetworkProfile networkProfile();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public AutoStorageProperties autoStorage();

    public EncryptionProperties encryption();

    public Integer dedicatedCoreQuota();

    public Integer lowPriorityCoreQuota();

    public List<VirtualMachineFamilyCoreQuota> dedicatedCoreQuotaPerVMFamily();

    public Boolean dedicatedCoreQuotaPerVMFamilyEnforced();

    public Integer poolQuota();

    public Integer activeJobAndJobScheduleQuota();

    public List<AuthenticationMode> allowedAuthenticationModes();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public BatchAccountInner innerModel();

    public Update update();

    public BatchAccount refresh();

    public BatchAccount refresh(Context var1);

    public Response<Void> synchronizeAutoStorageKeysWithResponse(Context var1);

    public void synchronizeAutoStorageKeys();

    public Response<BatchAccountKeys> regenerateKeyWithResponse(BatchAccountRegenerateKeyParameters var1, Context var2);

    public BatchAccountKeys regenerateKey(BatchAccountRegenerateKeyParameters var1);

    public Response<BatchAccountKeys> getKeysWithResponse(Context var1);

    public BatchAccountKeys getKeys();

    public static interface UpdateStages {

        public static interface WithNetworkProfile {
            public Update withNetworkProfile(NetworkProfile var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccessType var1);
        }

        public static interface WithAllowedAuthenticationModes {
            public Update withAllowedAuthenticationModes(List<AuthenticationMode> var1);
        }

        public static interface WithEncryption {
            public Update withEncryption(EncryptionProperties var1);
        }

        public static interface WithAutoStorage {
            public Update withAutoStorage(AutoStorageBaseProperties var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(BatchAccountIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithAutoStorage,
    UpdateStages.WithEncryption,
    UpdateStages.WithAllowedAuthenticationModes,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithNetworkProfile {
        public BatchAccount apply();

        public BatchAccount apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithAllowedAuthenticationModes {
            public WithCreate withAllowedAuthenticationModes(List<AuthenticationMode> var1);
        }

        public static interface WithEncryption {
            public WithCreate withEncryption(EncryptionProperties var1);
        }

        public static interface WithNetworkProfile {
            public WithCreate withNetworkProfile(NetworkProfile var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccessType var1);
        }

        public static interface WithKeyVaultReference {
            public WithCreate withKeyVaultReference(KeyVaultReference var1);
        }

        public static interface WithPoolAllocationMode {
            public WithCreate withPoolAllocationMode(PoolAllocationMode var1);
        }

        public static interface WithAutoStorage {
            public WithCreate withAutoStorage(AutoStorageBaseProperties var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(BatchAccountIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithAutoStorage,
        WithPoolAllocationMode,
        WithKeyVaultReference,
        WithPublicNetworkAccess,
        WithNetworkProfile,
        WithEncryption,
        WithAllowedAuthenticationModes {
            public BatchAccount create();

            public BatchAccount create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

