/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.fluent.models.BatchAccountCreateProperties;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.BatchAccountIdentity;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.KeyVaultReference;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PoolAllocationMode;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class BatchAccountCreateParameters {
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="properties")
    private BatchAccountCreateProperties innerProperties;
    @JsonProperty(value="identity")
    private BatchAccountIdentity identity;
    private static final ClientLogger LOGGER = new ClientLogger(BatchAccountCreateParameters.class);

    public String location() {
        return this.location;
    }

    public BatchAccountCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public BatchAccountCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private BatchAccountCreateProperties innerProperties() {
        return this.innerProperties;
    }

    public BatchAccountIdentity identity() {
        return this.identity;
    }

    public BatchAccountCreateParameters withIdentity(BatchAccountIdentity identity) {
        this.identity = identity;
        return this;
    }

    public AutoStorageBaseProperties autoStorage() {
        return this.innerProperties() == null ? null : this.innerProperties().autoStorage();
    }

    public BatchAccountCreateParameters withAutoStorage(AutoStorageBaseProperties autoStorage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withAutoStorage(autoStorage);
        return this;
    }

    public PoolAllocationMode poolAllocationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().poolAllocationMode();
    }

    public BatchAccountCreateParameters withPoolAllocationMode(PoolAllocationMode poolAllocationMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withPoolAllocationMode(poolAllocationMode);
        return this;
    }

    public KeyVaultReference keyVaultReference() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultReference();
    }

    public BatchAccountCreateParameters withKeyVaultReference(KeyVaultReference keyVaultReference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withKeyVaultReference(keyVaultReference);
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public BatchAccountCreateParameters withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfile();
    }

    public BatchAccountCreateParameters withNetworkProfile(NetworkProfile networkProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withNetworkProfile(networkProfile);
        return this;
    }

    public EncryptionProperties encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public BatchAccountCreateParameters withEncryption(EncryptionProperties encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedAuthenticationModes();
    }

    public BatchAccountCreateParameters withAllowedAuthenticationModes(List<AuthenticationMode> allowedAuthenticationModes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountCreateProperties();
        }
        this.innerProperties().withAllowedAuthenticationModes(allowedAuthenticationModes);
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model BatchAccountCreateParameters"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

