/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.ResourceIdentityType;
import com.azure.resourcemanager.batch.models.UserAssignedIdentities;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class BatchAccountIdentity {
    @JsonProperty(value="principalId", access=JsonProperty.Access.WRITE_ONLY)
    private String principalId;
    @JsonProperty(value="tenantId", access=JsonProperty.Access.WRITE_ONLY)
    private String tenantId;
    @JsonProperty(value="type", required=true)
    private ResourceIdentityType type;
    @JsonProperty(value="userAssignedIdentities")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, UserAssignedIdentities> userAssignedIdentities;
    private static final ClientLogger LOGGER = new ClientLogger(BatchAccountIdentity.class);

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ResourceIdentityType type() {
        return this.type;
    }

    public BatchAccountIdentity withType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserAssignedIdentities> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public BatchAccountIdentity withUserAssignedIdentities(Map<String, UserAssignedIdentities> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model BatchAccountIdentity"));
        }
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

