/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.resourcemanager.batch.fluent.models.BatchAccountUpdateProperties;
import com.azure.resourcemanager.batch.models.AuthenticationMode;
import com.azure.resourcemanager.batch.models.AutoStorageBaseProperties;
import com.azure.resourcemanager.batch.models.BatchAccountIdentity;
import com.azure.resourcemanager.batch.models.EncryptionProperties;
import com.azure.resourcemanager.batch.models.NetworkProfile;
import com.azure.resourcemanager.batch.models.PublicNetworkAccessType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class BatchAccountUpdateParameters {
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="properties")
    private BatchAccountUpdateProperties innerProperties;
    @JsonProperty(value="identity")
    private BatchAccountIdentity identity;

    public Map<String, String> tags() {
        return this.tags;
    }

    public BatchAccountUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private BatchAccountUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public BatchAccountIdentity identity() {
        return this.identity;
    }

    public BatchAccountUpdateParameters withIdentity(BatchAccountIdentity identity) {
        this.identity = identity;
        return this;
    }

    public AutoStorageBaseProperties autoStorage() {
        return this.innerProperties() == null ? null : this.innerProperties().autoStorage();
    }

    public BatchAccountUpdateParameters withAutoStorage(AutoStorageBaseProperties autoStorage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountUpdateProperties();
        }
        this.innerProperties().withAutoStorage(autoStorage);
        return this;
    }

    public EncryptionProperties encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public BatchAccountUpdateParameters withEncryption(EncryptionProperties encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountUpdateProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedAuthenticationModes();
    }

    public BatchAccountUpdateParameters withAllowedAuthenticationModes(List<AuthenticationMode> allowedAuthenticationModes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountUpdateProperties();
        }
        this.innerProperties().withAllowedAuthenticationModes(allowedAuthenticationModes);
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public BatchAccountUpdateParameters withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfile();
    }

    public BatchAccountUpdateParameters withNetworkProfile(NetworkProfile networkProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BatchAccountUpdateProperties();
        }
        this.innerProperties().withNetworkProfile(networkProfile);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

