/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.PoolIdentityType;
import com.azure.resourcemanager.batch.models.UserAssignedIdentities;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class BatchPoolIdentity {
    @JsonProperty(value="type", required=true)
    private PoolIdentityType type;
    @JsonProperty(value="userAssignedIdentities")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, UserAssignedIdentities> userAssignedIdentities;
    private static final ClientLogger LOGGER = new ClientLogger(BatchPoolIdentity.class);

    public PoolIdentityType type() {
        return this.type;
    }

    public BatchPoolIdentity withType(PoolIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserAssignedIdentities> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public BatchPoolIdentity withUserAssignedIdentities(Map<String, UserAssignedIdentities> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model BatchPoolIdentity"));
        }
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

