/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.batch.fluent.models.CertificateInner;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import com.azure.resourcemanager.batch.models.CertificateProvisioningState;
import com.azure.resourcemanager.batch.models.DeleteCertificateError;
import java.time.OffsetDateTime;

public interface Certificate {
    public String id();

    public String name();

    public String type();

    public String etag();

    public CertificateProvisioningState provisioningState();

    public OffsetDateTime provisioningStateTransitionTime();

    public CertificateProvisioningState previousProvisioningState();

    public OffsetDateTime previousProvisioningStateTransitionTime();

    public String publicData();

    public DeleteCertificateError deleteCertificateError();

    public String thumbprintAlgorithm();

    public String thumbprint();

    public CertificateFormat format();

    public String resourceGroupName();

    public CertificateInner innerModel();

    public Update update();

    public Certificate refresh();

    public Certificate refresh(Context var1);

    public Response<Certificate> cancelDeletionWithResponse(Context var1);

    public Certificate cancelDeletion();

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithFormat {
            public Update withFormat(CertificateFormat var1);
        }

        public static interface WithThumbprint {
            public Update withThumbprint(String var1);
        }

        public static interface WithThumbprintAlgorithm {
            public Update withThumbprintAlgorithm(String var1);
        }

        public static interface WithPassword {
            public Update withPassword(String var1);
        }

        public static interface WithData {
            public Update withData(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithData,
    UpdateStages.WithPassword,
    UpdateStages.WithThumbprintAlgorithm,
    UpdateStages.WithThumbprint,
    UpdateStages.WithFormat,
    UpdateStages.WithIfMatch {
        public Certificate apply();

        public Certificate apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithFormat {
            public WithCreate withFormat(CertificateFormat var1);
        }

        public static interface WithThumbprint {
            public WithCreate withThumbprint(String var1);
        }

        public static interface WithThumbprintAlgorithm {
            public WithCreate withThumbprintAlgorithm(String var1);
        }

        public static interface WithPassword {
            public WithCreate withPassword(String var1);
        }

        public static interface WithCreate
        extends WithPassword,
        WithThumbprintAlgorithm,
        WithThumbprint,
        WithFormat,
        WithIfMatch,
        WithIfNoneMatch {
            public Certificate create();

            public Certificate create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingBatchAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

