/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.ContainerRegistry;
import com.azure.resourcemanager.batch.models.ContainerType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ContainerConfiguration {
    @JsonProperty(value="type", required=true)
    private ContainerType type;
    @JsonProperty(value="containerImageNames")
    private List<String> containerImageNames;
    @JsonProperty(value="containerRegistries")
    private List<ContainerRegistry> containerRegistries;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerConfiguration.class);

    public ContainerType type() {
        return this.type;
    }

    public ContainerConfiguration withType(ContainerType type) {
        this.type = type;
        return this;
    }

    public List<String> containerImageNames() {
        return this.containerImageNames;
    }

    public ContainerConfiguration withContainerImageNames(List<String> containerImageNames) {
        this.containerImageNames = containerImageNames;
        return this;
    }

    public List<ContainerRegistry> containerRegistries() {
        return this.containerRegistries;
    }

    public ContainerConfiguration withContainerRegistries(List<ContainerRegistry> containerRegistries) {
        this.containerRegistries = containerRegistries;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model ContainerConfiguration"));
        }
        if (this.containerRegistries() != null) {
            this.containerRegistries().forEach(e -> e.validate());
        }
    }
}

