/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.NetworkSecurityGroupRuleAccess;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NetworkSecurityGroupRule {
    @JsonProperty(value="priority", required=true)
    private int priority;
    @JsonProperty(value="access", required=true)
    private NetworkSecurityGroupRuleAccess access;
    @JsonProperty(value="sourceAddressPrefix", required=true)
    private String sourceAddressPrefix;
    @JsonProperty(value="sourcePortRanges")
    private List<String> sourcePortRanges;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkSecurityGroupRule.class);

    public int priority() {
        return this.priority;
    }

    public NetworkSecurityGroupRule withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public NetworkSecurityGroupRuleAccess access() {
        return this.access;
    }

    public NetworkSecurityGroupRule withAccess(NetworkSecurityGroupRuleAccess access) {
        this.access = access;
        return this;
    }

    public String sourceAddressPrefix() {
        return this.sourceAddressPrefix;
    }

    public NetworkSecurityGroupRule withSourceAddressPrefix(String sourceAddressPrefix) {
        this.sourceAddressPrefix = sourceAddressPrefix;
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public NetworkSecurityGroupRule withSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public void validate() {
        if (this.access() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property access in model NetworkSecurityGroupRule"));
        }
        if (this.sourceAddressPrefix() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceAddressPrefix in model NetworkSecurityGroupRule"));
        }
    }
}

