/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.batch.fluent.models.PoolInner;
import com.azure.resourcemanager.batch.models.AllocationState;
import com.azure.resourcemanager.batch.models.ApplicationPackageReference;
import com.azure.resourcemanager.batch.models.AutoScaleRun;
import com.azure.resourcemanager.batch.models.BatchPoolIdentity;
import com.azure.resourcemanager.batch.models.CertificateReference;
import com.azure.resourcemanager.batch.models.DeploymentConfiguration;
import com.azure.resourcemanager.batch.models.InterNodeCommunicationState;
import com.azure.resourcemanager.batch.models.MetadataItem;
import com.azure.resourcemanager.batch.models.MountConfiguration;
import com.azure.resourcemanager.batch.models.NetworkConfiguration;
import com.azure.resourcemanager.batch.models.NodeCommunicationMode;
import com.azure.resourcemanager.batch.models.PoolProvisioningState;
import com.azure.resourcemanager.batch.models.ResizeOperationStatus;
import com.azure.resourcemanager.batch.models.ScaleSettings;
import com.azure.resourcemanager.batch.models.StartTask;
import com.azure.resourcemanager.batch.models.TaskSchedulingPolicy;
import com.azure.resourcemanager.batch.models.UserAccount;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface Pool {
    public String id();

    public String name();

    public String type();

    public BatchPoolIdentity identity();

    public String etag();

    public String displayName();

    public OffsetDateTime lastModified();

    public OffsetDateTime creationTime();

    public PoolProvisioningState provisioningState();

    public OffsetDateTime provisioningStateTransitionTime();

    public AllocationState allocationState();

    public OffsetDateTime allocationStateTransitionTime();

    public String vmSize();

    public DeploymentConfiguration deploymentConfiguration();

    public Integer currentDedicatedNodes();

    public Integer currentLowPriorityNodes();

    public ScaleSettings scaleSettings();

    public AutoScaleRun autoScaleRun();

    public InterNodeCommunicationState interNodeCommunication();

    public NetworkConfiguration networkConfiguration();

    public Integer taskSlotsPerNode();

    public TaskSchedulingPolicy taskSchedulingPolicy();

    public List<UserAccount> userAccounts();

    public List<MetadataItem> metadata();

    public StartTask startTask();

    public List<CertificateReference> certificates();

    public List<ApplicationPackageReference> applicationPackages();

    public List<String> applicationLicenses();

    public ResizeOperationStatus resizeOperationStatus();

    public List<MountConfiguration> mountConfiguration();

    public NodeCommunicationMode targetNodeCommunicationMode();

    public NodeCommunicationMode currentNodeCommunicationMode();

    public Map<String, String> resourceTags();

    public String resourceGroupName();

    public PoolInner innerModel();

    public Update update();

    public Pool refresh();

    public Pool refresh(Context var1);

    public Response<Pool> disableAutoScaleWithResponse(Context var1);

    public Pool disableAutoScale();

    public Response<Pool> stopResizeWithResponse(Context var1);

    public Pool stopResize();

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithResourceTags {
            public Update withResourceTags(Map<String, String> var1);
        }

        public static interface WithTargetNodeCommunicationMode {
            public Update withTargetNodeCommunicationMode(NodeCommunicationMode var1);
        }

        public static interface WithMountConfiguration {
            public Update withMountConfiguration(List<MountConfiguration> var1);
        }

        public static interface WithApplicationLicenses {
            public Update withApplicationLicenses(List<String> var1);
        }

        public static interface WithApplicationPackages {
            public Update withApplicationPackages(List<ApplicationPackageReference> var1);
        }

        public static interface WithCertificates {
            public Update withCertificates(List<CertificateReference> var1);
        }

        public static interface WithStartTask {
            public Update withStartTask(StartTask var1);
        }

        public static interface WithMetadata {
            public Update withMetadata(List<MetadataItem> var1);
        }

        public static interface WithUserAccounts {
            public Update withUserAccounts(List<UserAccount> var1);
        }

        public static interface WithTaskSchedulingPolicy {
            public Update withTaskSchedulingPolicy(TaskSchedulingPolicy var1);
        }

        public static interface WithTaskSlotsPerNode {
            public Update withTaskSlotsPerNode(Integer var1);
        }

        public static interface WithNetworkConfiguration {
            public Update withNetworkConfiguration(NetworkConfiguration var1);
        }

        public static interface WithInterNodeCommunication {
            public Update withInterNodeCommunication(InterNodeCommunicationState var1);
        }

        public static interface WithScaleSettings {
            public Update withScaleSettings(ScaleSettings var1);
        }

        public static interface WithDeploymentConfiguration {
            public Update withDeploymentConfiguration(DeploymentConfiguration var1);
        }

        public static interface WithVmSize {
            public Update withVmSize(String var1);
        }

        public static interface WithDisplayName {
            public Update withDisplayName(String var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(BatchPoolIdentity var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithIdentity,
    UpdateStages.WithDisplayName,
    UpdateStages.WithVmSize,
    UpdateStages.WithDeploymentConfiguration,
    UpdateStages.WithScaleSettings,
    UpdateStages.WithInterNodeCommunication,
    UpdateStages.WithNetworkConfiguration,
    UpdateStages.WithTaskSlotsPerNode,
    UpdateStages.WithTaskSchedulingPolicy,
    UpdateStages.WithUserAccounts,
    UpdateStages.WithMetadata,
    UpdateStages.WithStartTask,
    UpdateStages.WithCertificates,
    UpdateStages.WithApplicationPackages,
    UpdateStages.WithApplicationLicenses,
    UpdateStages.WithMountConfiguration,
    UpdateStages.WithTargetNodeCommunicationMode,
    UpdateStages.WithResourceTags,
    UpdateStages.WithIfMatch {
        public Pool apply();

        public Pool apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithResourceTags {
            public WithCreate withResourceTags(Map<String, String> var1);
        }

        public static interface WithTargetNodeCommunicationMode {
            public WithCreate withTargetNodeCommunicationMode(NodeCommunicationMode var1);
        }

        public static interface WithMountConfiguration {
            public WithCreate withMountConfiguration(List<MountConfiguration> var1);
        }

        public static interface WithApplicationLicenses {
            public WithCreate withApplicationLicenses(List<String> var1);
        }

        public static interface WithApplicationPackages {
            public WithCreate withApplicationPackages(List<ApplicationPackageReference> var1);
        }

        public static interface WithCertificates {
            public WithCreate withCertificates(List<CertificateReference> var1);
        }

        public static interface WithStartTask {
            public WithCreate withStartTask(StartTask var1);
        }

        public static interface WithMetadata {
            public WithCreate withMetadata(List<MetadataItem> var1);
        }

        public static interface WithUserAccounts {
            public WithCreate withUserAccounts(List<UserAccount> var1);
        }

        public static interface WithTaskSchedulingPolicy {
            public WithCreate withTaskSchedulingPolicy(TaskSchedulingPolicy var1);
        }

        public static interface WithTaskSlotsPerNode {
            public WithCreate withTaskSlotsPerNode(Integer var1);
        }

        public static interface WithNetworkConfiguration {
            public WithCreate withNetworkConfiguration(NetworkConfiguration var1);
        }

        public static interface WithInterNodeCommunication {
            public WithCreate withInterNodeCommunication(InterNodeCommunicationState var1);
        }

        public static interface WithScaleSettings {
            public WithCreate withScaleSettings(ScaleSettings var1);
        }

        public static interface WithDeploymentConfiguration {
            public WithCreate withDeploymentConfiguration(DeploymentConfiguration var1);
        }

        public static interface WithVmSize {
            public WithCreate withVmSize(String var1);
        }

        public static interface WithDisplayName {
            public WithCreate withDisplayName(String var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(BatchPoolIdentity var1);
        }

        public static interface WithCreate
        extends WithIdentity,
        WithDisplayName,
        WithVmSize,
        WithDeploymentConfiguration,
        WithScaleSettings,
        WithInterNodeCommunication,
        WithNetworkConfiguration,
        WithTaskSlotsPerNode,
        WithTaskSchedulingPolicy,
        WithUserAccounts,
        WithMetadata,
        WithStartTask,
        WithCertificates,
        WithApplicationPackages,
        WithApplicationLicenses,
        WithMountConfiguration,
        WithTargetNodeCommunicationMode,
        WithResourceTags,
        WithIfMatch,
        WithIfNoneMatch {
            public Pool create();

            public Pool create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingBatchAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

