/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.resourcemanager.batch.models.EnvironmentSetting;
import com.azure.resourcemanager.batch.models.ResourceFile;
import com.azure.resourcemanager.batch.models.TaskContainerSettings;
import com.azure.resourcemanager.batch.models.UserIdentity;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class StartTask {
    @JsonProperty(value="commandLine")
    private String commandLine;
    @JsonProperty(value="resourceFiles")
    private List<ResourceFile> resourceFiles;
    @JsonProperty(value="environmentSettings")
    private List<EnvironmentSetting> environmentSettings;
    @JsonProperty(value="userIdentity")
    private UserIdentity userIdentity;
    @JsonProperty(value="maxTaskRetryCount")
    private Integer maxTaskRetryCount;
    @JsonProperty(value="waitForSuccess")
    private Boolean waitForSuccess;
    @JsonProperty(value="containerSettings")
    private TaskContainerSettings containerSettings;

    public String commandLine() {
        return this.commandLine;
    }

    public StartTask withCommandLine(String commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    public List<ResourceFile> resourceFiles() {
        return this.resourceFiles;
    }

    public StartTask withResourceFiles(List<ResourceFile> resourceFiles) {
        this.resourceFiles = resourceFiles;
        return this;
    }

    public List<EnvironmentSetting> environmentSettings() {
        return this.environmentSettings;
    }

    public StartTask withEnvironmentSettings(List<EnvironmentSetting> environmentSettings) {
        this.environmentSettings = environmentSettings;
        return this;
    }

    public UserIdentity userIdentity() {
        return this.userIdentity;
    }

    public StartTask withUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
        return this;
    }

    public Integer maxTaskRetryCount() {
        return this.maxTaskRetryCount;
    }

    public StartTask withMaxTaskRetryCount(Integer maxTaskRetryCount) {
        this.maxTaskRetryCount = maxTaskRetryCount;
        return this;
    }

    public Boolean waitForSuccess() {
        return this.waitForSuccess;
    }

    public StartTask withWaitForSuccess(Boolean waitForSuccess) {
        this.waitForSuccess = waitForSuccess;
        return this;
    }

    public TaskContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public StartTask withContainerSettings(TaskContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
        return this;
    }

    public void validate() {
        if (this.resourceFiles() != null) {
            this.resourceFiles().forEach(e -> e.validate());
        }
        if (this.environmentSettings() != null) {
            this.environmentSettings().forEach(e -> e.validate());
        }
        if (this.userIdentity() != null) {
            this.userIdentity().validate();
        }
        if (this.containerSettings() != null) {
            this.containerSettings().validate();
        }
    }
}

