/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.ContainerRegistry;
import com.azure.resourcemanager.batch.models.ContainerWorkingDirectory;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class TaskContainerSettings {
    @JsonProperty(value="containerRunOptions")
    private String containerRunOptions;
    @JsonProperty(value="imageName", required=true)
    private String imageName;
    @JsonProperty(value="registry")
    private ContainerRegistry registry;
    @JsonProperty(value="workingDirectory")
    private ContainerWorkingDirectory workingDirectory;
    private static final ClientLogger LOGGER = new ClientLogger(TaskContainerSettings.class);

    public String containerRunOptions() {
        return this.containerRunOptions;
    }

    public TaskContainerSettings withContainerRunOptions(String containerRunOptions) {
        this.containerRunOptions = containerRunOptions;
        return this;
    }

    public String imageName() {
        return this.imageName;
    }

    public TaskContainerSettings withImageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    public ContainerRegistry registry() {
        return this.registry;
    }

    public TaskContainerSettings withRegistry(ContainerRegistry registry) {
        this.registry = registry;
        return this;
    }

    public ContainerWorkingDirectory workingDirectory() {
        return this.workingDirectory;
    }

    public TaskContainerSettings withWorkingDirectory(ContainerWorkingDirectory workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public void validate() {
        if (this.imageName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property imageName in model TaskContainerSettings"));
        }
        if (this.registry() != null) {
            this.registry().validate();
        }
    }
}

