/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.ElevationLevel;
import com.azure.resourcemanager.batch.models.LinuxUserConfiguration;
import com.azure.resourcemanager.batch.models.WindowsUserConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class UserAccount {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="elevationLevel")
    private ElevationLevel elevationLevel;
    @JsonProperty(value="linuxUserConfiguration")
    private LinuxUserConfiguration linuxUserConfiguration;
    @JsonProperty(value="windowsUserConfiguration")
    private WindowsUserConfiguration windowsUserConfiguration;
    private static final ClientLogger LOGGER = new ClientLogger(UserAccount.class);

    public String name() {
        return this.name;
    }

    public UserAccount withName(String name) {
        this.name = name;
        return this;
    }

    public String password() {
        return this.password;
    }

    public UserAccount withPassword(String password) {
        this.password = password;
        return this;
    }

    public ElevationLevel elevationLevel() {
        return this.elevationLevel;
    }

    public UserAccount withElevationLevel(ElevationLevel elevationLevel) {
        this.elevationLevel = elevationLevel;
        return this;
    }

    public LinuxUserConfiguration linuxUserConfiguration() {
        return this.linuxUserConfiguration;
    }

    public UserAccount withLinuxUserConfiguration(LinuxUserConfiguration linuxUserConfiguration) {
        this.linuxUserConfiguration = linuxUserConfiguration;
        return this;
    }

    public WindowsUserConfiguration windowsUserConfiguration() {
        return this.windowsUserConfiguration;
    }

    public UserAccount withWindowsUserConfiguration(WindowsUserConfiguration windowsUserConfiguration) {
        this.windowsUserConfiguration = windowsUserConfiguration;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model UserAccount"));
        }
        if (this.password() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property password in model UserAccount"));
        }
        if (this.linuxUserConfiguration() != null) {
            this.linuxUserConfiguration().validate();
        }
        if (this.windowsUserConfiguration() != null) {
            this.windowsUserConfiguration().validate();
        }
    }
}

