/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.models.ContainerConfiguration;
import com.azure.resourcemanager.batch.models.DataDisk;
import com.azure.resourcemanager.batch.models.DiskEncryptionConfiguration;
import com.azure.resourcemanager.batch.models.ImageReference;
import com.azure.resourcemanager.batch.models.NodePlacementConfiguration;
import com.azure.resourcemanager.batch.models.OSDisk;
import com.azure.resourcemanager.batch.models.SecurityProfile;
import com.azure.resourcemanager.batch.models.ServiceArtifactReference;
import com.azure.resourcemanager.batch.models.VMExtension;
import com.azure.resourcemanager.batch.models.WindowsConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VirtualMachineConfiguration {
    @JsonProperty(value="imageReference", required=true)
    private ImageReference imageReference;
    @JsonProperty(value="nodeAgentSkuId", required=true)
    private String nodeAgentSkuId;
    @JsonProperty(value="windowsConfiguration")
    private WindowsConfiguration windowsConfiguration;
    @JsonProperty(value="dataDisks")
    private List<DataDisk> dataDisks;
    @JsonProperty(value="licenseType")
    private String licenseType;
    @JsonProperty(value="containerConfiguration")
    private ContainerConfiguration containerConfiguration;
    @JsonProperty(value="diskEncryptionConfiguration")
    private DiskEncryptionConfiguration diskEncryptionConfiguration;
    @JsonProperty(value="nodePlacementConfiguration")
    private NodePlacementConfiguration nodePlacementConfiguration;
    @JsonProperty(value="extensions")
    private List<VMExtension> extensions;
    @JsonProperty(value="osDisk")
    private OSDisk osDisk;
    @JsonProperty(value="securityProfile")
    private SecurityProfile securityProfile;
    @JsonProperty(value="serviceArtifactReference")
    private ServiceArtifactReference serviceArtifactReference;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineConfiguration.class);

    public ImageReference imageReference() {
        return this.imageReference;
    }

    public VirtualMachineConfiguration withImageReference(ImageReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public String nodeAgentSkuId() {
        return this.nodeAgentSkuId;
    }

    public VirtualMachineConfiguration withNodeAgentSkuId(String nodeAgentSkuId) {
        this.nodeAgentSkuId = nodeAgentSkuId;
        return this;
    }

    public WindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    public VirtualMachineConfiguration withWindowsConfiguration(WindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
        return this;
    }

    public List<DataDisk> dataDisks() {
        return this.dataDisks;
    }

    public VirtualMachineConfiguration withDataDisks(List<DataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public VirtualMachineConfiguration withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public ContainerConfiguration containerConfiguration() {
        return this.containerConfiguration;
    }

    public VirtualMachineConfiguration withContainerConfiguration(ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    public DiskEncryptionConfiguration diskEncryptionConfiguration() {
        return this.diskEncryptionConfiguration;
    }

    public VirtualMachineConfiguration withDiskEncryptionConfiguration(DiskEncryptionConfiguration diskEncryptionConfiguration) {
        this.diskEncryptionConfiguration = diskEncryptionConfiguration;
        return this;
    }

    public NodePlacementConfiguration nodePlacementConfiguration() {
        return this.nodePlacementConfiguration;
    }

    public VirtualMachineConfiguration withNodePlacementConfiguration(NodePlacementConfiguration nodePlacementConfiguration) {
        this.nodePlacementConfiguration = nodePlacementConfiguration;
        return this;
    }

    public List<VMExtension> extensions() {
        return this.extensions;
    }

    public VirtualMachineConfiguration withExtensions(List<VMExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public OSDisk osDisk() {
        return this.osDisk;
    }

    public VirtualMachineConfiguration withOsDisk(OSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachineConfiguration withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public ServiceArtifactReference serviceArtifactReference() {
        return this.serviceArtifactReference;
    }

    public VirtualMachineConfiguration withServiceArtifactReference(ServiceArtifactReference serviceArtifactReference) {
        this.serviceArtifactReference = serviceArtifactReference;
        return this;
    }

    public void validate() {
        if (this.imageReference() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property imageReference in model VirtualMachineConfiguration"));
        }
        this.imageReference().validate();
        if (this.nodeAgentSkuId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property nodeAgentSkuId in model VirtualMachineConfiguration"));
        }
        if (this.windowsConfiguration() != null) {
            this.windowsConfiguration().validate();
        }
        if (this.dataDisks() != null) {
            this.dataDisks().forEach(e -> e.validate());
        }
        if (this.containerConfiguration() != null) {
            this.containerConfiguration().validate();
        }
        if (this.diskEncryptionConfiguration() != null) {
            this.diskEncryptionConfiguration().validate();
        }
        if (this.nodePlacementConfiguration() != null) {
            this.nodePlacementConfiguration().validate();
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.osDisk() != null) {
            this.osDisk().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.serviceArtifactReference() != null) {
            this.serviceArtifactReference().validate();
        }
    }
}

