// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AzureProxyResource;
import java.io.IOException;
import java.util.Map;

/**
 * Contains information about an application in a Batch account.
 */
@Fluent
public final class ApplicationInner extends AzureProxyResource {
    /*
     * The properties associated with the Application.
     */
    private ApplicationProperties innerProperties;

    /*
     * The ETag of the resource, used for concurrency statements.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApplicationInner class.
     */
    public ApplicationInner() {
    }

    /**
     * Get the innerProperties property: The properties associated with the Application.
     * 
     * @return the innerProperties value.
     */
    private ApplicationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: The ETag of the resource, used for concurrency statements.
     * 
     * @return the etag value.
     */
    @Override
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the displayName property: The display name for the application.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: The display name for the application.
     * 
     * @param displayName the displayName value to set.
     * @return the ApplicationInner object itself.
     */
    public ApplicationInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the allowUpdates property: A value indicating whether packages within the application may be overwritten
     * using the same version string.
     * 
     * @return the allowUpdates value.
     */
    public Boolean allowUpdates() {
        return this.innerProperties() == null ? null : this.innerProperties().allowUpdates();
    }

    /**
     * Set the allowUpdates property: A value indicating whether packages within the application may be overwritten
     * using the same version string.
     * 
     * @param allowUpdates the allowUpdates value to set.
     * @return the ApplicationInner object itself.
     */
    public ApplicationInner withAllowUpdates(Boolean allowUpdates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationProperties();
        }
        this.innerProperties().withAllowUpdates(allowUpdates);
        return this;
    }

    /**
     * Get the defaultVersion property: The package to use if a client requests the application but does not specify a
     * version. This property can only be set to the name of an existing package.
     * 
     * @return the defaultVersion value.
     */
    public String defaultVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultVersion();
    }

    /**
     * Set the defaultVersion property: The package to use if a client requests the application but does not specify a
     * version. This property can only be set to the name of an existing package.
     * 
     * @param defaultVersion the defaultVersion value to set.
     * @return the ApplicationInner object itself.
     */
    public ApplicationInner withDefaultVersion(String defaultVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationProperties();
        }
        this.innerProperties().withDefaultVersion(defaultVersion);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApplicationInner.
     */
    public static ApplicationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationInner deserializedApplicationInner = new ApplicationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApplicationInner.type = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedApplicationInner.etag = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApplicationInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationInner.innerProperties = ApplicationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationInner;
        });
    }
}
