// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AzureProxyResource;
import com.azure.resourcemanager.batch.models.PackageState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * An application package which represents a particular version of an application.
 */
@Fluent
public final class ApplicationPackageInner extends AzureProxyResource {
    /*
     * The properties associated with the Application Package.
     */
    private ApplicationPackageProperties innerProperties;

    /*
     * The ETag of the resource, used for concurrency statements.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApplicationPackageInner class.
     */
    public ApplicationPackageInner() {
    }

    /**
     * Get the innerProperties property: The properties associated with the Application Package.
     * 
     * @return the innerProperties value.
     */
    private ApplicationPackageProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: The ETag of the resource, used for concurrency statements.
     * 
     * @return the etag value.
     */
    @Override
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationPackageInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the state property: The current state of the application package.
     * 
     * @return the state value.
     */
    public PackageState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the format property: The format of the application package, if the package is active.
     * 
     * @return the format value.
     */
    public String format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    /**
     * Get the storageUrl property: The URL for the application package in Azure Storage.
     * 
     * @return the storageUrl value.
     */
    public String storageUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().storageUrl();
    }

    /**
     * Get the storageUrlExpiry property: The UTC time at which the Azure Storage URL will expire.
     * 
     * @return the storageUrlExpiry value.
     */
    public OffsetDateTime storageUrlExpiry() {
        return this.innerProperties() == null ? null : this.innerProperties().storageUrlExpiry();
    }

    /**
     * Get the lastActivationTime property: The time at which the package was last activated, if the package is active.
     * 
     * @return the lastActivationTime value.
     */
    public OffsetDateTime lastActivationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastActivationTime();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationPackageInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationPackageInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApplicationPackageInner.
     */
    public static ApplicationPackageInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationPackageInner deserializedApplicationPackageInner = new ApplicationPackageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationPackageInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationPackageInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApplicationPackageInner.type = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedApplicationPackageInner.etag = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApplicationPackageInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationPackageInner.innerProperties = ApplicationPackageProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationPackageInner;
        });
    }
}
