// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties associated with the Application.
 */
@Fluent
public final class ApplicationProperties implements JsonSerializable<ApplicationProperties> {
    /*
     * The display name for the application.
     */
    private String displayName;

    /*
     * A value indicating whether packages within the application may be overwritten using the same version string.
     */
    private Boolean allowUpdates;

    /*
     * The package to use if a client requests the application but does not specify a version. This property can only be
     * set to the name of an existing package.
     */
    private String defaultVersion;

    /**
     * Creates an instance of ApplicationProperties class.
     */
    public ApplicationProperties() {
    }

    /**
     * Get the displayName property: The display name for the application.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name for the application.
     * 
     * @param displayName the displayName value to set.
     * @return the ApplicationProperties object itself.
     */
    public ApplicationProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the allowUpdates property: A value indicating whether packages within the application may be overwritten
     * using the same version string.
     * 
     * @return the allowUpdates value.
     */
    public Boolean allowUpdates() {
        return this.allowUpdates;
    }

    /**
     * Set the allowUpdates property: A value indicating whether packages within the application may be overwritten
     * using the same version string.
     * 
     * @param allowUpdates the allowUpdates value to set.
     * @return the ApplicationProperties object itself.
     */
    public ApplicationProperties withAllowUpdates(Boolean allowUpdates) {
        this.allowUpdates = allowUpdates;
        return this;
    }

    /**
     * Get the defaultVersion property: The package to use if a client requests the application but does not specify a
     * version. This property can only be set to the name of an existing package.
     * 
     * @return the defaultVersion value.
     */
    public String defaultVersion() {
        return this.defaultVersion;
    }

    /**
     * Set the defaultVersion property: The package to use if a client requests the application but does not specify a
     * version. This property can only be set to the name of an existing package.
     * 
     * @param defaultVersion the defaultVersion value to set.
     * @return the ApplicationProperties object itself.
     */
    public ApplicationProperties withDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("allowUpdates", this.allowUpdates);
        jsonWriter.writeStringField("defaultVersion", this.defaultVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationProperties.
     */
    public static ApplicationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationProperties deserializedApplicationProperties = new ApplicationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedApplicationProperties.displayName = reader.getString();
                } else if ("allowUpdates".equals(fieldName)) {
                    deserializedApplicationProperties.allowUpdates = reader.getNullable(JsonReader::getBoolean);
                } else if ("defaultVersion".equals(fieldName)) {
                    deserializedApplicationProperties.defaultVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationProperties;
        });
    }
}
